/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.contentpacks.model.constraints.PluginVersionConstraint;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.LookupDataAdapterEntity;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ReferenceMapUtils;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.jackson.TypeReferences;
import org.graylog2.lookup.db.DBDataAdapterService;
import org.graylog2.lookup.dto.DataAdapterDto;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;

public class LookupDataAdapterFacade
implements EntityFacade<DataAdapterDto> {
    public static final ModelType TYPE_V1 = ModelTypes.LOOKUP_ADAPTER_V1;
    private final ObjectMapper objectMapper;
    private final DBDataAdapterService dataAdapterService;
    private final Set<PluginMetaData> pluginMetaData;

    @Inject
    public LookupDataAdapterFacade(ObjectMapper objectMapper, DBDataAdapterService dataAdapterService, Set<PluginMetaData> pluginMetaData) {
        this.objectMapper = objectMapper;
        this.dataAdapterService = dataAdapterService;
        this.pluginMetaData = pluginMetaData;
    }

    @VisibleForTesting
    Entity exportNativeEntity(DataAdapterDto dataAdapterDto, EntityDescriptorIds entityDescriptorIds) {
        Map configuration = (Map)this.objectMapper.convertValue((Object)dataAdapterDto.config(), TypeReferences.MAP_STRING_OBJECT);
        LookupDataAdapterEntity lookupDataAdapterEntity = LookupDataAdapterEntity.create(ValueReference.of(dataAdapterDto.scope()), ValueReference.of(dataAdapterDto.name()), ValueReference.of(dataAdapterDto.title()), ValueReference.of(dataAdapterDto.description()), ReferenceMapUtils.toReferenceMap(configuration));
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)lookupDataAdapterEntity, JsonNode.class);
        Set<Constraint> constraints = this.versionConstraints(dataAdapterDto);
        return ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(entityDescriptorIds.getOrThrow(dataAdapterDto.id(), ModelTypes.LOOKUP_ADAPTER_V1)))).type(ModelTypes.LOOKUP_ADAPTER_V1)).constraints((ImmutableSet<Constraint>)ImmutableSet.copyOf(constraints)).data(data).build();
    }

    private Set<Constraint> versionConstraints(DataAdapterDto dataAdapterDto) {
        String packageName = dataAdapterDto.config().getClass().getPackage().getName();
        return this.pluginMetaData.stream().filter(metaData -> packageName.startsWith(metaData.getClass().getPackage().getName())).map(PluginVersionConstraint::of).collect(Collectors.toSet());
    }

    @Override
    public NativeEntity<DataAdapterDto> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + String.valueOf(entity.getClass()));
    }

    private NativeEntity<DataAdapterDto> decode(EntityV1 entity, Map<String, ValueReference> parameters) {
        LookupDataAdapterEntity lookupDataAdapterEntity = (LookupDataAdapterEntity)this.objectMapper.convertValue((Object)entity.data(), LookupDataAdapterEntity.class);
        LookupDataAdapterConfiguration configuration = (LookupDataAdapterConfiguration)this.objectMapper.convertValue(ReferenceMapUtils.toValueMap(lookupDataAdapterEntity.configuration(), parameters), LookupDataAdapterConfiguration.class);
        DataAdapterDto dataAdapterDto = ((DataAdapterDto.Builder)DataAdapterDto.builder().scope(lookupDataAdapterEntity.scope().asString(parameters))).name(lookupDataAdapterEntity.name().asString(parameters)).title(lookupDataAdapterEntity.title().asString(parameters)).description(lookupDataAdapterEntity.description().asString(parameters)).config(configuration).build();
        DataAdapterDto savedDataAdapterDto = this.dataAdapterService.saveAndPostEvent(dataAdapterDto);
        return NativeEntity.create(entity.id(), savedDataAdapterDto.id(), TYPE_V1, savedDataAdapterDto.title(), savedDataAdapterDto);
    }

    @Override
    public Optional<NativeEntity<DataAdapterDto>> findExisting(Entity entity, Map<String, ValueReference> parameters) {
        if (entity instanceof EntityV1) {
            return this.findExisting((EntityV1)entity, parameters);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + String.valueOf(entity.getClass()));
    }

    private Optional<NativeEntity<DataAdapterDto>> findExisting(EntityV1 entity, Map<String, ValueReference> parameters) {
        LookupDataAdapterEntity dataAdapterEntity = (LookupDataAdapterEntity)this.objectMapper.convertValue((Object)entity.data(), LookupDataAdapterEntity.class);
        String name = dataAdapterEntity.name().asString(parameters);
        Optional<DataAdapterDto> existingDataAdapter = this.dataAdapterService.get(name);
        return existingDataAdapter.map(dataAdapter -> NativeEntity.create(entity.id(), dataAdapter.id(), TYPE_V1, dataAdapter.title(), dataAdapter));
    }

    @Override
    public Optional<NativeEntity<DataAdapterDto>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        return this.dataAdapterService.get(nativeEntityDescriptor.id().id()).map(entity -> NativeEntity.create(nativeEntityDescriptor, entity));
    }

    @Override
    public void delete(DataAdapterDto nativeEntity) {
        this.dataAdapterService.deleteAndPostEventImmutable(nativeEntity.id());
    }

    @Override
    public EntityExcerpt createExcerpt(DataAdapterDto dataAdapterDto) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(dataAdapterDto.id()))).type(ModelTypes.LOOKUP_ADAPTER_V1)).title(dataAdapterDto.title()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.dataAdapterService.findAll().stream().map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Optional<Entity> exportEntity(EntityDescriptor entityDescriptor, EntityDescriptorIds entityDescriptorIds) {
        ModelId modelId = entityDescriptor.id();
        return this.dataAdapterService.get(modelId.id()).map(dataAdapterDto -> this.exportNativeEntity((DataAdapterDto)dataAdapterDto, entityDescriptorIds));
    }

    @Override
    public boolean usesScopedEntities() {
        return true;
    }
}

