/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.PositiveOrZero;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.views.WidgetPositionDTO;
import org.graylog2.contentpacks.model.entities.AutoValue_DashboardWidgetEntity;
import org.graylog2.contentpacks.model.entities.AutoValue_DashboardWidgetEntity_Position;
import org.graylog2.contentpacks.model.entities.TimeRangeEntity;
import org.graylog2.contentpacks.model.entities.references.ReferenceMap;
import org.graylog2.contentpacks.model.entities.references.ValueReference;

@JsonAutoDetect
@AutoValue
public abstract class DashboardWidgetEntity {
    @JsonProperty(value="id")
    @NotNull
    public abstract ValueReference id();

    @JsonProperty(value="description")
    @NotNull
    public abstract ValueReference description();

    @JsonProperty(value="type")
    @NotBlank
    public abstract ValueReference type();

    @JsonProperty(value="cache_time")
    @PositiveOrZero
    public abstract ValueReference cacheTime();

    @JsonProperty(value="time_range")
    @NotNull
    public abstract TimeRangeEntity timeRange();

    @JsonProperty(value="configuration")
    @NotNull
    public abstract ReferenceMap configuration();

    @JsonProperty(value="position")
    public abstract Optional<Position> position();

    @JsonCreator
    public static DashboardWidgetEntity create(@JsonProperty(value="id") @NotNull ValueReference id, @JsonProperty(value="description") @NotNull ValueReference description, @JsonProperty(value="type") @NotBlank ValueReference type, @JsonProperty(value="cache_time") @PositiveOrZero ValueReference cacheTime, @JsonProperty(value="time_range") @NotNull TimeRangeEntity timeRange, @JsonProperty(value="configuration") @NotNull ReferenceMap configuration, @JsonProperty(value="position") @Nullable Position position) {
        return new AutoValue_DashboardWidgetEntity(id, description, type, cacheTime, timeRange, configuration, Optional.ofNullable(position));
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class Position {
        @JsonProperty(value="width")
        @PositiveOrZero
        public abstract ValueReference width();

        @JsonProperty(value="height")
        @PositiveOrZero
        public abstract ValueReference height();

        @JsonProperty(value="row")
        @PositiveOrZero
        public abstract ValueReference row();

        @JsonProperty(value="col")
        @PositiveOrZero
        public abstract ValueReference col();

        @JsonCreator
        public static Position create(@JsonProperty(value="width") @PositiveOrZero ValueReference width, @JsonProperty(value="height") @PositiveOrZero ValueReference height, @JsonProperty(value="row") @PositiveOrZero ValueReference row, @JsonProperty(value="col") @PositiveOrZero ValueReference col) {
            return new AutoValue_DashboardWidgetEntity_Position(width, height, row, col);
        }

        public WidgetPositionDTO convert(Map<String, ValueReference> parameters) {
            return WidgetPositionDTO.Builder.create().col(org.graylog.plugins.views.search.views.Position.fromInt(this.col().asInteger(parameters))).row(org.graylog.plugins.views.search.views.Position.fromInt(this.row().asInteger(parameters))).height(org.graylog.plugins.views.search.views.Position.fromInt(this.height().asInteger(parameters))).width(org.graylog.plugins.views.search.views.Position.fromInt(this.width().asInteger(parameters))).build();
        }
    }
}

