/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities.references;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.graylog2.contentpacks.model.entities.references.AutoValue_ValueReference;
import org.graylog2.contentpacks.model.entities.references.Reference;
import org.graylog2.contentpacks.model.entities.references.ValueType;
import org.graylog2.security.encryption.EncryptedValue;

@JsonAutoDetect
@JsonDeserialize(builder=AutoValue_ValueReference.Builder.class)
@AutoValue
public abstract class ValueReference
implements Reference {
    public static final String FIELD_TYPE = "@type";
    public static final String FIELD_VALUE = "@value";

    @JsonProperty(value="@type")
    public abstract ValueType valueType();

    @JsonProperty(value="@value")
    public abstract Object value();

    public Boolean asBoolean(Map<String, ValueReference> parameters) {
        switch (this.valueType()) {
            case BOOLEAN: {
                return (Boolean)Boolean.class.cast(this.value());
            }
            case PARAMETER: {
                return this.asType(parameters, Boolean.class);
            }
        }
        throw new IllegalStateException("Expected value reference of type BOOLEAN but got " + String.valueOf((Object)this.valueType()));
    }

    public Double asDouble(Map<String, ValueReference> parameters) {
        switch (this.valueType()) {
            case DOUBLE: {
                if (this.value() instanceof Number) {
                    return ((Number)this.value()).doubleValue();
                }
                throw new IllegalStateException("Expected value reference of type DOUBLE but got " + String.valueOf(this.value().getClass()));
            }
            case PARAMETER: {
                return this.asType(parameters, Double.class);
            }
        }
        throw new IllegalStateException("Expected value reference of type DOUBLE but got " + String.valueOf((Object)this.valueType()));
    }

    public Float asFloat(Map<String, ValueReference> parameters) {
        switch (this.valueType()) {
            case FLOAT: {
                if (this.value() instanceof Number) {
                    return Float.valueOf(((Number)this.value()).floatValue());
                }
                throw new IllegalStateException("Expected value reference of type FLOAT but got " + String.valueOf(this.value().getClass()));
            }
            case PARAMETER: {
                return this.asType(parameters, Float.class);
            }
        }
        throw new IllegalStateException("Expected value reference of type FLOAT but got " + String.valueOf((Object)this.valueType()));
    }

    public Integer asInteger(Map<String, ValueReference> parameters) {
        switch (this.valueType()) {
            case INTEGER: {
                return (Integer)Integer.class.cast(this.value());
            }
            case PARAMETER: {
                return this.asType(parameters, Integer.class);
            }
        }
        throw new IllegalStateException("Expected value reference of type INTEGER but got " + String.valueOf((Object)this.valueType()));
    }

    public Long asLong(Map<String, ValueReference> parameters) {
        switch (this.valueType()) {
            case LONG: {
                if (this.value() instanceof Number) {
                    return ((Number)this.value()).longValue();
                }
                throw new IllegalStateException("Expected value reference of type LONG but got " + String.valueOf(this.value().getClass()));
            }
            case PARAMETER: {
                return this.asType(parameters, Long.class);
            }
        }
        throw new IllegalStateException("Expected value reference of type LONG but got " + String.valueOf((Object)this.valueType()));
    }

    public String asString(Map<String, ValueReference> parameters) {
        switch (this.valueType()) {
            case STRING: {
                return (String)String.class.cast(this.value());
            }
            case PARAMETER: {
                return this.asType(parameters, String.class);
            }
        }
        throw new IllegalStateException("Expected value reference of type STRING but got " + String.valueOf((Object)this.valueType()));
    }

    public String asString() {
        switch (this.valueType()) {
            case STRING: {
                return (String)String.class.cast(this.value());
            }
        }
        throw new IllegalStateException("Expected value reference of type STRING but got " + String.valueOf((Object)this.valueType()));
    }

    private <S> S asType(Map<String, ValueReference> parameters, Class<S> type) {
        if (this.valueType() == ValueType.PARAMETER) {
            String value = (String)String.class.cast(this.value());
            ValueReference filledParameter = parameters.get(value);
            if (filledParameter.valueType().targetClass().equals(type)) {
                return type.cast(filledParameter.value());
            }
            throw new IllegalStateException("Expected parameter reference for Java type " + String.valueOf(type) + " but got " + String.valueOf((Object)filledParameter.valueType()));
        }
        throw new IllegalStateException("Expected value reference of type PARAMETER but got " + String.valueOf((Object)this.valueType()));
    }

    public <S extends Enum<S>> S asEnum(Map<String, ValueReference> parameters, Class<S> type) {
        return Enum.valueOf(type, switch (this.valueType()) {
            case ValueType.STRING -> (String)String.class.cast(this.value());
            case ValueType.PARAMETER -> this.asType(parameters, String.class);
            default -> throw new IllegalStateException("Expected value reference of type STRING or PARAMETER but got " + String.valueOf((Object)this.valueType()));
        });
    }

    @Nullable
    public static ValueReference of(Object value) {
        if (value instanceof Boolean) {
            return ValueReference.of((Boolean)value);
        }
        if (value instanceof Double) {
            return ValueReference.of((Double)value);
        }
        if (value instanceof Float) {
            return ValueReference.of((Float)value);
        }
        if (value instanceof Integer) {
            return ValueReference.of((Integer)value);
        }
        if (value instanceof Long) {
            return ValueReference.of((Long)value);
        }
        if (value instanceof String) {
            return ValueReference.of((String)value);
        }
        if (value instanceof Enum) {
            return ValueReference.of((Enum)value);
        }
        if (value instanceof EncryptedValue) {
            EncryptedValue encryptedValue = (EncryptedValue)value;
            return ValueReference.of(encryptedValue);
        }
        return null;
    }

    public static ValueReference of(Boolean value) {
        return ValueReference.builder().valueType(ValueType.BOOLEAN).value(value).build();
    }

    public static ValueReference of(Double value) {
        return ValueReference.builder().valueType(ValueType.DOUBLE).value(value).build();
    }

    public static ValueReference of(Float value) {
        return ValueReference.builder().valueType(ValueType.FLOAT).value(value).build();
    }

    public static ValueReference of(Integer value) {
        return ValueReference.builder().valueType(ValueType.INTEGER).value(value).build();
    }

    public static ValueReference of(Long value) {
        return ValueReference.builder().valueType(ValueType.LONG).value(value).build();
    }

    public static ValueReference ofNullable(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return ValueReference.of(value);
    }

    public static ValueReference of(@NotNull String value) {
        return ValueReference.builder().valueType(ValueType.STRING).value(value).build();
    }

    public static ValueReference ofNullable(@Nullable Enum value) {
        if (value == null) {
            return null;
        }
        return ValueReference.of(value);
    }

    public static ValueReference of(@Nonnull Enum value) {
        return ValueReference.builder().valueType(ValueType.STRING).value(value.name()).build();
    }

    public static ValueReference of(@Nonnull EncryptedValue value) {
        if (!value.isSet()) {
            return null;
        }
        return ValueReference.builder().valueType(ValueType.STRING).value("<Encrypted value was replaced with this text for content pack export. Consider adding a parameter for this field.>").build();
    }

    public static ValueReference createParameter(String value) {
        return ValueReference.builder().valueType(ValueType.PARAMETER).value(value).build();
    }

    public static Builder builder() {
        return new AutoValue_ValueReference.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty(value="@type")
        public abstract Builder valueType(ValueType var1);

        @JsonProperty(value="@value")
        public abstract Builder value(Object var1);

        abstract ValueReference autoBuild();

        public ValueReference build() {
            boolean isParameter;
            ValueReference valueReference = this.autoBuild();
            boolean bl = isParameter = valueReference.valueType() == ValueType.PARAMETER;
            if (isParameter) {
                String value = (String)valueReference.value();
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)"Parameter must not be blank");
            }
            return valueReference;
        }
    }
}

