/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.pagination;

import com.google.common.primitives.Ints;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Collation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.bson.conversions.Bson;
import org.graylog2.database.MongoEntity;
import org.graylog2.database.PaginatedList;
import org.graylog2.database.pagination.MongoPaginationHelper;
import org.graylog2.database.utils.MongoUtils;

public class DefaultMongoPaginationHelper<T extends MongoEntity>
implements MongoPaginationHelper<T> {
    private final MongoCollection<T> collection;
    private final Bson filter;
    private final Bson sort;
    private final Bson projection;
    private final int perPage;
    private final boolean includeGrandTotal;
    private final Bson grandTotalFilter;
    private final Collation collation;

    public DefaultMongoPaginationHelper(MongoCollection<T> collection) {
        this(collection, null, null, null, 0, false, null, null);
    }

    private DefaultMongoPaginationHelper(MongoCollection<T> collection, Bson filter, Bson sort, Bson projection, int perPage, boolean includeGrandTotal, Bson grandTotalFilter, Collation collation) {
        this.collection = collection;
        this.filter = filter;
        this.sort = sort;
        this.projection = projection;
        this.perPage = perPage;
        this.includeGrandTotal = includeGrandTotal;
        this.grandTotalFilter = grandTotalFilter;
        this.collation = collation;
    }

    @Override
    public MongoPaginationHelper<T> filter(Bson filter) {
        return new DefaultMongoPaginationHelper<T>(this.collection, filter, this.sort, this.projection, this.perPage, this.includeGrandTotal, this.grandTotalFilter, this.collation);
    }

    @Override
    public MongoPaginationHelper<T> sort(Bson sort) {
        return new DefaultMongoPaginationHelper<T>(this.collection, this.filter, sort, this.projection, this.perPage, this.includeGrandTotal, this.grandTotalFilter, this.collation);
    }

    @Override
    public MongoPaginationHelper<T> projection(Bson projection) {
        return new DefaultMongoPaginationHelper<T>(this.collection, this.filter, this.sort, projection, this.perPage, this.includeGrandTotal, this.grandTotalFilter, this.collation);
    }

    @Override
    public MongoPaginationHelper<T> perPage(int perPage) {
        return new DefaultMongoPaginationHelper<T>(this.collection, this.filter, this.sort, this.projection, perPage, this.includeGrandTotal, this.grandTotalFilter, this.collation);
    }

    @Override
    public MongoPaginationHelper<T> includeGrandTotal(boolean includeGrandTotal) {
        return new DefaultMongoPaginationHelper<T>(this.collection, this.filter, this.sort, this.projection, this.perPage, includeGrandTotal, this.grandTotalFilter, this.collation);
    }

    @Override
    public MongoPaginationHelper<T> grandTotalFilter(Bson grandTotalFilter) {
        return new DefaultMongoPaginationHelper<T>(this.collection, this.filter, this.sort, this.projection, this.perPage, this.includeGrandTotal, grandTotalFilter, this.collation);
    }

    @Override
    public MongoPaginationHelper<T> collation(Collation collation) {
        return new DefaultMongoPaginationHelper<T>(this.collection, this.filter, this.sort, this.projection, this.perPage, this.includeGrandTotal, this.grandTotalFilter, collation);
    }

    @Override
    public PaginatedList<T> page(int pageNumber) {
        List documents = (List)this.getFindIterableBase().skip(this.perPage * Math.max(0, pageNumber - 1)).limit(this.perPage).into(new ArrayList());
        int total = Ints.saturatedCast((long)this.collection.countDocuments(this.filter));
        if (this.includeGrandTotal) {
            long grandTotal = this.collection.countDocuments(this.grandTotalFilter);
            return new PaginatedList(documents, total, pageNumber, this.perPage, grandTotal);
        }
        return new PaginatedList(documents, total, pageNumber, this.perPage);
    }

    @Override
    public PaginatedList<T> page(int pageNumber, Predicate<T> selector) {
        int total = Ints.saturatedCast((long)MongoUtils.stream(this.collection.find().filter(this.filter).sort(this.sort)).filter(selector).count());
        List<T> documents = this.perPage > 0 ? MongoUtils.stream(this.getFindIterableBase()).filter(selector).skip((long)this.perPage * Math.max(0L, (long)(pageNumber - 1))).limit(this.perPage).toList() : MongoUtils.stream(this.getFindIterableBase()).filter(selector).toList();
        if (this.includeGrandTotal) {
            long grandTotal = this.collection.countDocuments(this.grandTotalFilter);
            return new PaginatedList<T>(documents, total, pageNumber, this.perPage, grandTotal);
        }
        return new PaginatedList<T>(documents, total, pageNumber, this.perPage);
    }

    private FindIterable<T> getFindIterableBase() {
        FindIterable findIterable = this.collection.find().filter(this.filter).sort(this.sort).collation(this.collation);
        if (this.projection != null) {
            findIterable = findIterable.projection(this.projection);
        }
        return findIterable;
    }
}

