/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.datanode;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;

public record RemoteReindexAllowlistEvent(List<String> allowlist, ACTION action, List<String> pemEncodedTrustedCertificates) {
    public static RemoteReindexAllowlistEvent add(List<String> allowlist) {
        return RemoteReindexAllowlistEvent.add(allowlist, Collections.emptyList());
    }

    public static RemoteReindexAllowlistEvent add(List<String> allowlist, List<String> trustedCertificates) {
        return new RemoteReindexAllowlistEvent(allowlist, ACTION.ADD, trustedCertificates);
    }

    public static RemoteReindexAllowlistEvent remove() {
        return new RemoteReindexAllowlistEvent(Collections.emptyList(), ACTION.REMOVE, Collections.emptyList());
    }

    @JsonIgnore
    public List<X509Certificate> trustedCertificates() {
        return this.pemEncodedTrustedCertificates.stream().map(RemoteReindexAllowlistEvent::decode).collect(Collectors.toList());
    }

    private static X509Certificate decode(String pemEncodedCert) {
        PEMParser pemParser = new PEMParser((Reader)new StringReader(pemEncodedCert));
        try {
            Object parsed = pemParser.readObject();
            if (parsed instanceof X509CertificateHolder) {
                X509CertificateHolder certificate = (X509CertificateHolder)parsed;
                return new JcaX509CertificateConverter().getCertificate(certificate);
            }
            throw new IllegalArgumentException("Couldn't parse x509 certificate from provided string, unknown type");
        }
        catch (IOException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum ACTION {
        ADD,
        REMOVE;

    }
}

