/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.datanode;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import jakarta.inject.Inject;
import java.util.Locale;
import java.util.Optional;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoCollections;
import org.graylog2.database.utils.MongoUtils;
import org.graylog2.indexer.datanode.MigrationConfiguration;
import org.graylog2.indexer.datanode.RemoteReindexMigrationService;
import org.graylog2.indexer.migration.LogEntry;

public class RemoteReindexMigrationServiceImpl
implements RemoteReindexMigrationService {
    public static final String COLLECTION_NAME = "remote_reindex_migrations";
    private final MongoCollection<MigrationConfiguration> collection;
    private final MongoUtils<MigrationConfiguration> mongoUtils;

    @Inject
    public RemoteReindexMigrationServiceImpl(MongoCollections mongoCollections) {
        this.collection = mongoCollections.collection(COLLECTION_NAME, MigrationConfiguration.class);
        this.mongoUtils = mongoCollections.utils(this.collection);
    }

    @Override
    public Optional<MigrationConfiguration> getMigration(String migrationId) {
        return this.mongoUtils.getById(migrationId);
    }

    @Override
    public MigrationConfiguration saveMigration(MigrationConfiguration migrationConfiguration) {
        String id = MongoUtils.insertedIdAsString(this.collection.insertOne((Object)migrationConfiguration));
        return this.mongoUtils.getById(id).orElseThrow();
    }

    @Override
    public void assignTask(String migrationID, String indexName, String taskId) {
        Bson update;
        Bson filter = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)new ObjectId(migrationID)), Filters.eq((String)"indices.indexName", (Object)indexName)});
        if (this.collection.updateOne(filter, update = Updates.set((String)"indices.$.taskId", (Object)taskId)).getModifiedCount() != 1L) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Failed to update migration %s. Index %s doesn't exist in the migration", migrationID, indexName));
        }
    }

    @Override
    public void appendLogEntry(String migrationId, LogEntry log) {
        Bson update;
        Bson filter = Filters.eq((String)"_id", (Object)new ObjectId(migrationId));
        if (this.collection.updateOne(filter, update = Updates.push((String)"logs", (Object)log)).getModifiedCount() != 1L) {
            throw new IllegalStateException("Failed to append log entry:" + String.valueOf(log));
        }
    }

    @Override
    public Optional<String> getLatestMigrationId() {
        return Optional.ofNullable((MigrationConfiguration)this.collection.find().sort((Bson)new Document("_id", (Object)-1)).limit(1).first()).map(MigrationConfiguration::id);
    }
}

