/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.fieldtypes;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Nullable;
import org.graylog2.indexer.fieldtypes.FieldTypeDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesDTO;
import org.mongojack.Id;
import org.mongojack.ObjectId;

final class AutoValue_IndexFieldTypesDTO
extends IndexFieldTypesDTO {
    @Nullable
    private final String id;
    private final String indexSetId;
    private final String indexName;
    private final ImmutableSet<FieldTypeDTO> fields;
    private final boolean hasStreamData;

    private AutoValue_IndexFieldTypesDTO(@Nullable String id, String indexSetId, String indexName, ImmutableSet<FieldTypeDTO> fields, boolean hasStreamData) {
        this.id = id;
        this.indexSetId = indexSetId;
        this.indexName = indexName;
        this.fields = fields;
        this.hasStreamData = hasStreamData;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    @Id
    @ObjectId
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="index_set_id")
    public String indexSetId() {
        return this.indexSetId;
    }

    @Override
    @JsonProperty(value="index_name")
    public String indexName() {
        return this.indexName;
    }

    @Override
    @JsonProperty(value="fields")
    public ImmutableSet<FieldTypeDTO> fields() {
        return this.fields;
    }

    @Override
    @JsonProperty(value="has_stream_data")
    public boolean hasStreamData() {
        return this.hasStreamData;
    }

    public String toString() {
        return "IndexFieldTypesDTO{id=" + this.id + ", indexSetId=" + this.indexSetId + ", indexName=" + this.indexName + ", fields=" + String.valueOf(this.fields) + ", hasStreamData=" + this.hasStreamData + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IndexFieldTypesDTO) {
            IndexFieldTypesDTO that = (IndexFieldTypesDTO)o;
            return (this.id == null ? that.id() == null : this.id.equals(that.id())) && this.indexSetId.equals(that.indexSetId()) && this.indexName.equals(that.indexName()) && this.fields.equals(that.fields()) && this.hasStreamData == that.hasStreamData();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id == null ? 0 : this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexSetId.hashCode();
        h$ *= 1000003;
        h$ ^= this.indexName.hashCode();
        h$ *= 1000003;
        h$ ^= this.fields.hashCode();
        h$ *= 1000003;
        return h$ ^= this.hasStreamData ? 1231 : 1237;
    }

    @Override
    public IndexFieldTypesDTO.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends IndexFieldTypesDTO.Builder {
        private String id;
        private String indexSetId;
        private String indexName;
        private ImmutableSet.Builder<FieldTypeDTO> fieldsBuilder$;
        private ImmutableSet<FieldTypeDTO> fields;
        private boolean hasStreamData;
        private byte set$0;

        Builder() {
        }

        Builder(IndexFieldTypesDTO source) {
            this.id = source.id();
            this.indexSetId = source.indexSetId();
            this.indexName = source.indexName();
            this.fields = source.fields();
            this.hasStreamData = source.hasStreamData();
            this.set$0 = 1;
        }

        @Override
        public IndexFieldTypesDTO.Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public IndexFieldTypesDTO.Builder indexSetId(String indexSetId) {
            if (indexSetId == null) {
                throw new NullPointerException("Null indexSetId");
            }
            this.indexSetId = indexSetId;
            return this;
        }

        @Override
        public IndexFieldTypesDTO.Builder indexName(String indexName) {
            if (indexName == null) {
                throw new NullPointerException("Null indexName");
            }
            this.indexName = indexName;
            return this;
        }

        @Override
        ImmutableSet.Builder<FieldTypeDTO> fieldsBuilder() {
            if (this.fieldsBuilder$ == null) {
                if (this.fields == null) {
                    this.fieldsBuilder$ = ImmutableSet.builder();
                } else {
                    this.fieldsBuilder$ = ImmutableSet.builder();
                    this.fieldsBuilder$.addAll(this.fields);
                    this.fields = null;
                }
            }
            return this.fieldsBuilder$;
        }

        @Override
        public IndexFieldTypesDTO.Builder hasStreamData(boolean hasStreamData) {
            this.hasStreamData = hasStreamData;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public IndexFieldTypesDTO build() {
            if (this.fieldsBuilder$ != null) {
                this.fields = this.fieldsBuilder$.build();
            } else if (this.fields == null) {
                this.fields = ImmutableSet.of();
            }
            if (this.set$0 != 1 || this.indexSetId == null || this.indexName == null) {
                StringBuilder missing = new StringBuilder();
                if (this.indexSetId == null) {
                    missing.append(" indexSetId");
                }
                if (this.indexName == null) {
                    missing.append(" indexName");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" hasStreamData");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_IndexFieldTypesDTO(this.id, this.indexSetId, this.indexName, this.fields, this.hasStreamData);
        }
    }
}

