/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.fieldtypes.mapping;

import jakarta.inject.Inject;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.indexer.MongoIndexSet;
import org.graylog2.indexer.indexset.CustomFieldMapping;
import org.graylog2.indexer.indexset.CustomFieldMappings;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indexset.IndexSetService;
import org.graylog2.indexer.indexset.MongoIndexSetService;
import org.graylog2.indexer.indexset.profile.IndexFieldTypeProfile;
import org.graylog2.indexer.indexset.profile.IndexFieldTypeProfileService;
import org.graylog2.plugin.Message;
import org.graylog2.rest.bulk.model.BulkOperationFailure;
import org.graylog2.rest.bulk.model.BulkOperationResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypeMappingsService {
    private static final Logger LOG = LoggerFactory.getLogger(FieldTypeMappingsService.class);
    private final IndexSetService indexSetService;
    private final MongoIndexSet.Factory mongoIndexSetFactory;
    private final MongoIndexSetService mongoIndexSetService;
    private final IndexFieldTypeProfileService profileService;

    @Inject
    public FieldTypeMappingsService(IndexSetService indexSetService, MongoIndexSet.Factory mongoIndexSetFactory, MongoIndexSetService mongoIndexSetService, IndexFieldTypeProfileService profileService) {
        this.indexSetService = indexSetService;
        this.mongoIndexSetFactory = mongoIndexSetFactory;
        this.mongoIndexSetService = mongoIndexSetService;
        this.profileService = profileService;
    }

    public void changeFieldType(CustomFieldMapping customMapping, Set<String> indexSetsIds, boolean rotateImmediately) {
        this.checkFieldTypeCanBeChanged(customMapping.fieldName());
        this.checkType(customMapping);
        this.checkAllIndicesSupportFieldTypeChange(customMapping.fieldName(), indexSetsIds);
        for (String indexSetId : indexSetsIds) {
            try {
                this.indexSetService.get(indexSetId).ifPresent(indexSetConfig -> {
                    Optional<IndexSetConfig> updatedIndexSetConfig = this.storeMapping(customMapping, (IndexSetConfig)indexSetConfig);
                    if (rotateImmediately) {
                        updatedIndexSetConfig.ifPresent(this::cycleIndexSet);
                    }
                });
            }
            catch (Exception ex) {
                LOG.error("Failed to update field type in index set : " + indexSetId, (Throwable)ex);
                throw ex;
            }
        }
    }

    public void setProfile(Set<String> indexSetsIds, String profileId, boolean rotateImmediately) {
        this.checkProfile(profileId);
        this.checkAllIndicesSupportProfileChange(indexSetsIds);
        for (String indexSetId : indexSetsIds) {
            try {
                this.indexSetService.get(indexSetId).ifPresent(indexSetConfig -> {
                    Optional<IndexSetConfig> updatedIndexSetConfig = this.setProfileForIndexSet(profileId, (IndexSetConfig)indexSetConfig);
                    if (rotateImmediately) {
                        updatedIndexSetConfig.ifPresent(this::cycleIndexSet);
                    }
                });
            }
            catch (Exception ex) {
                LOG.error("Failed to update field type in index set : " + indexSetId, (Throwable)ex);
                throw ex;
            }
        }
    }

    public void removeProfileFromIndexSets(Set<String> indexSetsIds, boolean rotateImmediately) {
        for (String indexSetId : indexSetsIds) {
            try {
                this.indexSetService.get(indexSetId).ifPresent(indexSetConfig -> {
                    Optional<IndexSetConfig> updatedIndexSetConfig = this.removeProfileFromIndexSet((IndexSetConfig)indexSetConfig);
                    if (rotateImmediately) {
                        updatedIndexSetConfig.ifPresent(this::cycleIndexSet);
                    }
                });
            }
            catch (Exception ex) {
                LOG.error("Failed to update field type in index set : " + indexSetId, (Throwable)ex);
                throw ex;
            }
        }
    }

    public Map<String, BulkOperationResponse> removeCustomMappingForFields(List<String> fieldNames, Set<String> indexSetsIds, boolean rotateImmediately) {
        HashMap<String, BulkOperationResponse> result = new HashMap<String, BulkOperationResponse>();
        for (String indexSetId : indexSetsIds) {
            try {
                this.indexSetService.get(indexSetId).ifPresentOrElse(indexSetConfig -> result.put(indexSetId, this.removeMappings(fieldNames, (IndexSetConfig)indexSetConfig, rotateImmediately)), () -> result.put(indexSetId, new BulkOperationResponse(List.of("Index set with following ID not present in the database: " + indexSetId))));
            }
            catch (Exception ex) {
                LOG.error("Failed to remove custom mappings for fields " + fieldNames.toString() + " in index set : " + indexSetId, (Throwable)ex);
                result.put(indexSetId, new BulkOperationResponse(List.of("Exception while removing custom field mappings for index set : " + indexSetId + ": " + ex.getMessage())));
            }
        }
        return result;
    }

    private BulkOperationResponse removeMappings(List<String> fieldNames, IndexSetConfig indexSetConfig, boolean rotateImmediately) {
        CustomFieldMappings previousCustomFieldMappings = indexSetConfig.customFieldMappings();
        Set fieldsWithoutCustomMappings = fieldNames.stream().filter(fieldName -> !previousCustomFieldMappings.containsCustomMappingForField((String)fieldName)).collect(Collectors.toSet());
        boolean removedSmth = previousCustomFieldMappings.removeIf(customFieldMapping -> fieldNames.stream().anyMatch(fieldName -> customFieldMapping.fieldName().equals(fieldName)));
        int fieldsRemoved = fieldNames.size() - fieldsWithoutCustomMappings.size();
        List failures = fieldsWithoutCustomMappings.stream().map(f -> new BulkOperationFailure((String)f, "Field not present in custom mappings")).collect(Collectors.toCollection(ArrayList::new));
        LinkedList<String> errors = new LinkedList<String>();
        if (removedSmth) {
            Optional<IndexSetConfig> updatedIndexSetConfig = Optional.of(this.mongoIndexSetService.save(indexSetConfig.toBuilder().customFieldMappings(previousCustomFieldMappings).build()));
            if (rotateImmediately) {
                try {
                    updatedIndexSetConfig.ifPresent(this::cycleIndexSet);
                }
                catch (Exception ex) {
                    errors.add("Failed to rotate index set after successful custom mapping removal: " + ex.getMessage());
                    LOG.error("Failed to rotate index set after successful custom mapping removal for fields " + fieldNames.toString() + " in index set : " + indexSetConfig.id(), (Throwable)ex);
                }
            }
        }
        return new BulkOperationResponse(fieldsRemoved, failures, errors);
    }

    private Optional<IndexSetConfig> storeMapping(CustomFieldMapping customMapping, IndexSetConfig indexSetConfig) {
        CustomFieldMappings previousCustomFieldMappings = indexSetConfig.customFieldMappings();
        if (previousCustomFieldMappings.contains(customMapping)) {
            return Optional.empty();
        }
        return Optional.of(this.mongoIndexSetService.save(indexSetConfig.toBuilder().customFieldMappings(previousCustomFieldMappings.mergeWith(customMapping)).build()));
    }

    private Optional<IndexSetConfig> setProfileForIndexSet(String profileId, IndexSetConfig indexSetConfig) {
        if (Objects.equals(indexSetConfig.fieldTypeProfile(), profileId)) {
            return Optional.empty();
        }
        return Optional.of(this.mongoIndexSetService.save(indexSetConfig.toBuilder().fieldTypeProfile(profileId).build()));
    }

    private Optional<IndexSetConfig> removeProfileFromIndexSet(IndexSetConfig indexSetConfig) {
        if (indexSetConfig.fieldTypeProfile() == null) {
            return Optional.empty();
        }
        return Optional.of(this.mongoIndexSetService.save(indexSetConfig.toBuilder().fieldTypeProfile(null).build()));
    }

    private void cycleIndexSet(IndexSetConfig indexSetConfig) {
        MongoIndexSet mongoIndexSet = this.mongoIndexSetFactory.create(indexSetConfig);
        mongoIndexSet.cycle();
    }

    private void checkType(CustomFieldMapping customMapping) {
        CustomFieldMappings.TypeDescription type = CustomFieldMappings.AVAILABLE_TYPES.get(customMapping.type());
        if (type == null) {
            throw new BadRequestException("Invalid type provided: " + customMapping.type() + " - available types: " + String.valueOf(CustomFieldMappings.AVAILABLE_TYPES.keySet()));
        }
    }

    private void checkProfile(String profileId) {
        Optional<IndexFieldTypeProfile> fieldTypeProfile = this.profileService.get(profileId);
        if (!fieldTypeProfile.isPresent()) {
            throw new NotFoundException("No profile with id : " + profileId);
        }
        fieldTypeProfile.get().customFieldMappings().forEach(mapping -> this.checkFieldTypeCanBeChanged(mapping.fieldName()));
    }

    private void checkFieldTypeCanBeChanged(String fieldName) {
        if (Message.FIELDS_UNCHANGEABLE_BY_CUSTOM_MAPPINGS.contains((Object)fieldName)) {
            throw new BadRequestException("Unable to change field type of " + fieldName + ", not allowed to change type of these fields: " + String.valueOf(Message.FIELDS_UNCHANGEABLE_BY_CUSTOM_MAPPINGS));
        }
    }

    private void checkAllIndicesSupportFieldTypeChange(String fieldName, Set<String> indexSetsIds) {
        List<IndexSetConfig> indexSetConfigs = this.filterOutIndicesThatCannotHaveFieldTypeChanged(indexSetsIds);
        if (!indexSetConfigs.isEmpty()) {
            throw new BadRequestException("Unable to change field type of " + fieldName + ", not allowed to change type in indices : " + String.valueOf(indexSetConfigs.stream().map(IndexSetConfig::title).toList()));
        }
    }

    private void checkAllIndicesSupportProfileChange(Set<String> indexSetsIds) {
        List<IndexSetConfig> indexSetConfigs = this.filterOutIndicesThatCannotHaveProfileSet(indexSetsIds);
        if (!indexSetConfigs.isEmpty()) {
            throw new BadRequestException("Unable to change profile in indices : " + String.valueOf(indexSetConfigs.stream().map(IndexSetConfig::title).toList()));
        }
    }

    private List<IndexSetConfig> filterOutIndicesThatCannotHaveFieldTypeChanged(Set<String> indexSetsIds) {
        return indexSetsIds.stream().map(this.indexSetService::get).filter(Optional::isPresent).map(Optional::get).filter(index -> !index.canHaveCustomFieldMappings()).toList();
    }

    private List<IndexSetConfig> filterOutIndicesThatCannotHaveProfileSet(Set<String> indexSetsIds) {
        return indexSetsIds.stream().map(this.indexSetService::get).filter(Optional::isPresent).map(Optional::get).filter(index -> !index.canHaveProfile()).toList();
    }
}

