/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.rotation.common;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Objects;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.NoTargetIndexException;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRotator {
    private static final Logger LOG = LoggerFactory.getLogger(IndexRotator.class);
    private final Indices indices;
    private final AuditEventSender auditEventSender;
    private final NodeId nodeId;

    @Inject
    public IndexRotator(Indices indices, AuditEventSender auditEventSender, NodeId nodeId) {
        this.indices = indices;
        this.auditEventSender = auditEventSender;
        this.nodeId = nodeId;
    }

    public static Result createResult(boolean shouldRotate, String message, String rotatorClass) {
        return new Result(shouldRotate, message, rotatorClass);
    }

    public void rotate(IndexSet indexSet, RotationChecker rotationChecker) {
        String indexName;
        Objects.requireNonNull(indexSet, "indexSet must not be null");
        String indexSetTitle = Objects.requireNonNull(indexSet.getConfig(), "Index set configuration must not be null").title();
        try {
            indexName = indexSet.getNewestIndex();
        }
        catch (NoTargetIndexException e) {
            LOG.error("Could not find current deflector target of index set <{}>. Aborting.", (Object)indexSetTitle, (Object)e);
            return;
        }
        this.indices.refresh(indexName);
        Result rotate = rotationChecker.shouldRotate(indexName, indexSet);
        if (rotate == null) {
            LOG.error("Cannot perform rotation of index <{}> in index set <{}> at this moment", (Object)indexName, (Object)indexSetTitle);
            return;
        }
        LOG.debug("Rotation strategy result: {}", (Object)rotate.getDescription());
        if (rotate.shouldRotate()) {
            LOG.info("Deflector index <{}> (index set <{}>) should be rotated ({}), Pointing deflector to new index now!", new Object[]{indexSetTitle, indexName, rotate.getDescription()});
            indexSet.cycle();
            this.auditEventSender.success(AuditActor.system(this.nodeId), "server:es_index_rotation:complete", (Map<String, Object>)ImmutableMap.of((Object)"index_name", (Object)indexName, (Object)"rotation_strategy", (Object)rotate.getRotatorClass()));
        } else {
            LOG.debug("Deflector index <{}> should not be rotated. Not doing anything.", (Object)indexName);
        }
    }

    public static class Result {
        private final boolean shouldRotate;
        private final String message;
        private final String rotatorClass;

        public Result(boolean shouldRotate, String message, String rotatorClass) {
            this.shouldRotate = shouldRotate;
            this.message = message;
            this.rotatorClass = rotatorClass;
            LOG.debug("{} because of: {}", (Object)(shouldRotate ? "Rotating" : "Not rotating"), (Object)message);
        }

        public String getDescription() {
            return this.message;
        }

        public boolean shouldRotate() {
            return this.shouldRotate;
        }

        public String getRotatorClass() {
            return this.rotatorClass;
        }
    }

    public static interface RotationChecker {
        public Result shouldRotate(String var1, IndexSet var2);
    }
}

