/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.searches;

import java.util.Locale;
import java.util.Optional;

public class Sorting {
    public static final Sorting DEFAULT = new Sorting("timestamp", Direction.DESC);
    private final String field;
    private final Direction direction;
    private final String unmappedType;

    public Sorting(String field, Direction direction, String unmappedType) {
        this.field = field;
        this.direction = direction;
        this.unmappedType = unmappedType;
    }

    public Sorting(String field, Direction direction) {
        this.field = field;
        this.direction = direction;
        this.unmappedType = null;
    }

    public String getField() {
        return this.field;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Optional<String> getUnmappedType() {
        return Optional.ofNullable(this.unmappedType);
    }

    public static Sorting fromApiParam(String param) {
        if (param == null || !param.contains(":")) {
            throw new IllegalArgumentException("Invalid sorting parameter: " + param);
        }
        String[] parts = param.split(":");
        return new Sorting(parts[0], Direction.valueOf(parts[1].toUpperCase(Locale.ENGLISH)));
    }

    public static enum Direction {
        ASC,
        DESC;

    }
}

