/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.Updates;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.AutoValue_V20220623125450_AddJobTypeToJobTrigger_MigrationStatus;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20220623125450_AddJobTypeToJobTrigger
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20220623125450_AddJobTypeToJobTrigger.class);
    private final MongoConnection mongoConnection;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public V20220623125450_AddJobTypeToJobTrigger(MongoConnection mongoConnection, ClusterConfigService clusterConfigService) {
        this.mongoConnection = mongoConnection;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2022-06-23T12:54:50Z");
    }

    @Override
    public void upgrade() {
        long elapsed;
        MigrationStatus migrationStatus = this.clusterConfigService.getOrDefault(MigrationStatus.class, MigrationStatus.createEmpty());
        Stopwatch started = Stopwatch.createStarted();
        MongoCollection jobTriggers = this.mongoConnection.getMongoDatabase().getCollection("scheduler_triggers");
        MongoCollection jobDefinitions = this.mongoConnection.getMongoDatabase().getCollection("scheduler_job_definitions");
        Map<String, String> typeMap = Streams.stream((Iterable)jobDefinitions.find()).collect(Collectors.toMap(d -> d.getObjectId((Object)"_id").toString(), d -> (String)d.getEmbedded((List)ImmutableList.of((Object)"config", (Object)"type"), String.class)));
        FindIterable query = jobTriggers.find(Filters.exists((String)"job_definition_type", (boolean)false));
        List typeUpdate = Streams.stream((Iterable)query).map(d -> new UpdateOneModel(Filters.eq((String)"_id", (Object)d.getObjectId((Object)"_id")), Updates.set((String)"job_definition_type", (Object)((String)typeMap.get(d.getString((Object)"job_definition_id")))))).collect(Collectors.toList());
        long modifiedCount = 0L;
        if (!typeUpdate.isEmpty()) {
            modifiedCount = jobTriggers.bulkWrite(typeUpdate).getModifiedCount();
            LOG.info("Added type field to <{}> JobTriggers", (Object)modifiedCount);
        }
        if ((elapsed = started.stop().elapsed(TimeUnit.SECONDS)) > 60L) {
            LOG.warn("Migration ran longer than expected! Took <{}> seconds", (Object)elapsed);
        }
        this.clusterConfigService.write(MigrationStatus.create(migrationStatus.convertedTriggersCount() + modifiedCount, migrationStatus.executionCount() + 1));
    }

    @AutoValue
    public static abstract class MigrationStatus {
        @JsonProperty(value="converted_triggers_count")
        public abstract long convertedTriggersCount();

        @JsonProperty(value="execution_count")
        public abstract int executionCount();

        @JsonCreator
        public static MigrationStatus create(@JsonProperty(value="converted_triggers_count") long convertedTriggersCount, @JsonProperty(value="execution_count") int executionCount) {
            return new AutoValue_V20220623125450_AddJobTypeToJobTrigger_MigrationStatus(convertedTriggersCount, executionCount);
        }

        public static MigrationStatus createEmpty() {
            return MigrationStatus.create(0L, 0);
        }
    }
}

