/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.auto.value.AutoValue;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.graylog2.indexer.searches.SearchesClusterConfig;
import org.graylog2.indexer.searches.timerangepresets.TimerangePreset;
import org.graylog2.indexer.searches.timerangepresets.conversion.TimerangeOptionsToTimerangePresetsConversion;
import org.graylog2.migrations.AutoValue_V202305221200_MigrateTimerangeOptionsToTimerangePresets_MigrationCompleted;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V202305221200_MigrateTimerangeOptionsToTimerangePresets
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V202305221200_MigrateTimerangeOptionsToTimerangePresets.class);
    private final ClusterConfigService clusterConfigService;
    private final TimerangeOptionsToTimerangePresetsConversion conversion;

    @Inject
    public V202305221200_MigrateTimerangeOptionsToTimerangePresets(ClusterConfigService clusterConfigService, TimerangeOptionsToTimerangePresetsConversion conversion) {
        this.clusterConfigService = clusterConfigService;
        this.conversion = conversion;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-05-22T12:00:00Z");
    }

    @Override
    public void upgrade() {
        Map<Period, String> relativeTimerangeOptions;
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        SearchesClusterConfig searchesClusterConfig = this.clusterConfigService.get(SearchesClusterConfig.class);
        if (searchesClusterConfig != null && (relativeTimerangeOptions = searchesClusterConfig.relativeTimerangeOptions()) != null && !relativeTimerangeOptions.isEmpty()) {
            List<TimerangePreset> converted = this.conversion.convert(relativeTimerangeOptions);
            List<TimerangePreset> quickAccessTimerangePresets = searchesClusterConfig.quickAccessTimerangePresets();
            ArrayList<TimerangePreset> newQuickAccessTimerangePresets = new ArrayList<TimerangePreset>();
            if (quickAccessTimerangePresets != null) {
                newQuickAccessTimerangePresets.addAll(quickAccessTimerangePresets);
            }
            newQuickAccessTimerangePresets.addAll(converted);
            SearchesClusterConfig newConfig = searchesClusterConfig.toBuilder().quickAccessTimerangePresets(newQuickAccessTimerangePresets).build();
            this.clusterConfigService.write(newConfig);
            this.clusterConfigService.write(MigrationCompleted.create());
            LOG.info("Migration created " + relativeTimerangeOptions.size() + " new entries in quickAccessTimerangePresets list, based on relativeTimerangeOptions list");
            return;
        }
        LOG.info("Migration was not needed, no relativeTimerangeOptions data to move");
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonCreator
        public static MigrationCompleted create() {
            return new AutoValue_V202305221200_MigrateTimerangeOptionsToTimerangePresets_MigrationCompleted();
        }
    }
}

