/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Optional;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventDefinition;
import org.graylog.scheduler.DBJobDefinitionService;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20230523160600_PopulateEventDefinitionState
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20230523160600_PopulateEventDefinitionState.class);
    private final ClusterConfigService clusterConfigService;
    private final DBEventDefinitionService dbEventDefinitionService;
    private final DBJobDefinitionService dbJobDefinitionService;

    @Inject
    public V20230523160600_PopulateEventDefinitionState(ClusterConfigService clusterConfigService, DBEventDefinitionService dbEventDefinitionService, DBJobDefinitionService dbJobDefinitionService) {
        this.clusterConfigService = clusterConfigService;
        this.dbEventDefinitionService = dbEventDefinitionService;
        this.dbJobDefinitionService = dbJobDefinitionService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-05-26T16:06:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed!");
            return;
        }
        ArrayList enabledEventDefinitionIds = new ArrayList();
        this.dbEventDefinitionService.streamAll().forEach(dto -> {
            Optional<JobDefinitionDto> jobDefinition = this.dbJobDefinitionService.getByConfigField("event_definition_id", dto.id());
            if (dto.scope().equals("SYSTEM_NOTIFICATION_EVENT") || jobDefinition.isPresent()) {
                enabledEventDefinitionIds.add(dto.id());
            }
        });
        enabledEventDefinitionIds.forEach(id -> this.dbEventDefinitionService.updateState((String)id, EventDefinition.State.ENABLED));
        this.clusterConfigService.write(new MigrationCompleted());
    }

    public record MigrationCompleted() {
    }
}

