/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.value.AutoValue;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.graylog2.contentpacks.ContentPackInstallationPersistenceService;
import org.graylog2.contentpacks.ContentPackPersistenceService;
import org.graylog2.contentpacks.ContentPackService;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.model.ContentPack;
import org.graylog2.contentpacks.model.ContentPackInstallation;
import org.graylog2.contentpacks.model.Identified;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.AutoValue_V20230601104500_AddSourcesPageV2_MigrationCompleted;
import org.graylog2.migrations.Migration;
import org.graylog2.migrations.V20191219090834_AddSourcesPage;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20230601104500_AddSourcesPageV2
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20191219090834_AddSourcesPage.class);
    private static final Date UNMODIFIED_SOURCES_SEARCH_DATE = new Date(1574420327255L);
    private final ContentPackService contentPackService;
    private final ObjectMapper objectMapper;
    private final ClusterConfigService configService;
    private final ContentPackPersistenceService contentPackPersistenceService;
    private final ContentPackInstallationPersistenceService contentPackInstallationPersistenceService;
    private final MongoCollection<Document> views;
    private final MongoCollection<Document> searches;
    private final MongoCollection<Document> contentPackInstallations;
    private final NotificationService notificationService;

    @Inject
    public V20230601104500_AddSourcesPageV2(ContentPackService contentPackService, ObjectMapper objectMapper, ClusterConfigService configService, ContentPackPersistenceService contentPackPersistenceService, ContentPackInstallationPersistenceService contentPackInstallationPersistenceService, MongoConnection mongoConnection, NotificationService notificationService) {
        this.contentPackService = contentPackService;
        this.objectMapper = objectMapper;
        this.configService = configService;
        this.contentPackPersistenceService = contentPackPersistenceService;
        this.contentPackInstallationPersistenceService = contentPackInstallationPersistenceService;
        this.views = mongoConnection.getMongoDatabase().getCollection("views");
        this.searches = mongoConnection.getMongoDatabase().getCollection("searches");
        this.contentPackInstallations = mongoConnection.getMongoDatabase().getCollection("content_packs_installations");
        this.notificationService = notificationService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-06-01T10:45:00Z");
    }

    @Override
    public void upgrade() {
        if (this.configService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        Optional<V20191219090834_AddSourcesPage.MigrationCompleted> previousMigration = Optional.ofNullable(this.configService.get(V20191219090834_AddSourcesPage.MigrationCompleted.class));
        Optional previousInstallation = previousMigration.flatMap(this::previousInstallation);
        boolean notPreviouslyInstalled = previousInstallation.isEmpty();
        ContentPack contentPack = this.readContentPack();
        Optional<ContentPackInstallation> contentPackShouldBeUninstalled = previousInstallation.filter(this::userHasNotModifiedSourcesPage);
        boolean notLocallyModified = contentPackShouldBeUninstalled.isPresent();
        Optional previousDashboard = contentPackShouldBeUninstalled.flatMap(this::dashboardFromInstallation);
        ContentPack pack = this.insertContentPack(contentPack).orElseThrow(() -> {
            this.configService.write(MigrationCompleted.create(contentPack.id().toString(), false, false));
            return new ContentPackException("Content pack " + String.valueOf(contentPack.id()) + " with this revision " + contentPack.revision() + " already found!");
        });
        contentPackShouldBeUninstalled.ifPresent(this::uninstallContentPack);
        if (notPreviouslyInstalled || notLocallyModified) {
            ContentPackInstallation newInstallation = this.installContentPack(pack);
            assert (newInstallation != null);
            previousDashboard.ifPresent(dashboard -> this.fixupNewDashboardId((Document)dashboard, newInstallation));
        } else {
            this.notificationService.publishIfFirst(this.notificationService.buildNow().addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.NORMAL).addDetail("title", "Updating Sources Dashboard").addDetail("description", "While updating the Sources Dashboard, it was detected that the previous version was modified locally. To save these modifications from getting lost,\na new version of the content pack containing the Sources Dashboard was uploaded, but not installed.\n\nIf you want to use the new version of the dashboard, you can go to \"System\" -> \"Content Packs\" -> \"Sources Page Dashboard\" and install version 2.\nIn addition, you can either keep your current \"Sources\" dashboard (having two \"Sources\" dashboards) or uninstall version 1 of the content pack to remove it.\n"));
        }
        this.configService.write(MigrationCompleted.create(pack.id().toString(), notPreviouslyInstalled || notLocallyModified, contentPackShouldBeUninstalled.isPresent()));
    }

    private void fixupNewDashboardId(Document previousDashboard, ContentPackInstallation newInstallation) {
        Optional<Document> newDashboard = this.dashboardFromInstallation(newInstallation);
        ObjectId previousDashboardId = previousDashboard.getObjectId((Object)"_id");
        newDashboard.ifPresent(dashboard -> {
            ObjectId newDashboardId = dashboard.getObjectId((Object)"_id");
            dashboard.append("_id", (Object)previousDashboardId);
            this.views.deleteOne(Filters.eq((String)"_id", (Object)newDashboardId));
            this.views.insertOne(dashboard);
            this.contentPackInstallations.updateOne(Filters.eq((String)"_id", (Object)newInstallation.id()), Updates.set((String)"entities.0.id", (Object)previousDashboardId.toHexString()));
        });
    }

    private Optional<ContentPackInstallation> previousInstallation(V20191219090834_AddSourcesPage.MigrationCompleted previousMigration) {
        return Optional.ofNullable(previousMigration.contentPackId()).map(id -> this.contentPackInstallationPersistenceService.findByContentPackId(ModelId.of(id))).flatMap(installations -> installations.stream().filter(installation -> installation.contentPackRevision() == 1 && installation.createdBy().equals("admin") && installation.comment().equals("Add Sources Page")).findFirst());
    }

    private Optional<Document> dashboardFromInstallation(ContentPackInstallation installation) {
        return Optional.ofNullable(installation.entities()).flatMap(entities -> entities.stream().findFirst()).map(Identified::id).map(ModelId::id).flatMap(dashboardId -> Optional.ofNullable((Document)this.views.find(Filters.eq((String)"_id", (Object)new ObjectId(dashboardId))).first()));
    }

    private boolean userHasNotModifiedSourcesPage(ContentPackInstallation previousInstallation) {
        Optional<Date> previousDashboard = this.dashboardFromInstallation(previousInstallation).flatMap(dashboard -> Optional.ofNullable(dashboard.getString((Object)"search_id"))).flatMap(searchId -> Optional.ofNullable((Document)this.searches.find(Filters.eq((String)"_id", (Object)new ObjectId(searchId))).first()));
        Boolean userHasModifiedSourcesPage = previousDashboard.map(dashboard -> dashboard.getDate((Object)"created_at")).map(createdAt -> !createdAt.equals(UNMODIFIED_SOURCES_SEARCH_DATE)).orElse(false);
        return userHasModifiedSourcesPage == false;
    }

    private ContentPackInstallation installContentPack(ContentPack contentPack) {
        return this.contentPackService.installContentPack(contentPack, Collections.emptyMap(), "Add Sources Page V2", "admin");
    }

    private Optional<ContentPack> insertContentPack(ContentPack contentPack) {
        return this.contentPackPersistenceService.insert(contentPack);
    }

    private void uninstallContentPack(ContentPackInstallation contentPackInstallation) {
        this.contentPackPersistenceService.findByIdAndRevision(contentPackInstallation.contentPackId(), contentPackInstallation.contentPackRevision()).ifPresent(contentPack -> this.contentPackService.uninstallContentPack((ContentPack)contentPack, contentPackInstallation));
    }

    private ContentPack readContentPack() {
        try {
            URL contentPackURL = V20230601104500_AddSourcesPageV2.class.getResource("V20230601104500_AddSourcesPage_V2_Content_Pack.json");
            return (ContentPack)this.objectMapper.readValue(contentPackURL, ContentPack.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read content pack source in migration: ", e);
        }
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="content_pack_id")
        public abstract String contentPackId();

        @JsonProperty(value="installed_content_pack")
        public abstract boolean installedContentPack();

        @JsonProperty(value="uninstalled_previous_revision")
        public abstract boolean uninstalledPreviousRevision();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="content_pack_id") String contentPackId, @JsonProperty(value="installed_content_pack") boolean installedContentPack, @JsonProperty(value="uninstalled_previous_revision") boolean uninstalledPreviousRevision) {
            return new AutoValue_V20230601104500_AddSourcesPageV2_MigrationCompleted(contentPackId, installedContentPack, uninstalledPreviousRevision);
        }
    }
}

