/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs.filter;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.db.RuleMetricsConfigDto;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog2.outputs.filter.PipelineRuleOutputFilter;
import org.graylog2.plugin.Message;

public class PipelineRuleOutputFilterState
extends PipelineInterpreter.State {
    private final ImmutableSet<String> destinations;
    private final ImmutableSet<String> activeStreams;

    @Inject
    public PipelineRuleOutputFilterState(@Assisted(value="pipelines") ImmutableMap<String, Pipeline> pipelines, @Assisted(value="destinations") ImmutableSet<String> destinations, @Assisted(value="activeStreams") ImmutableSet<String> activeStreams, MetricRegistry metricRegistry, @Named(value="processbuffer_processors") int processorCount, @Named(value="cached_stageiterators") boolean cachedIterators) {
        super(pipelines, (ImmutableSetMultimap<String, Pipeline>)ImmutableSetMultimap.of(), RuleMetricsConfigDto.createDefault(), metricRegistry, processorCount, cachedIterators);
        this.destinations = destinations;
        this.activeStreams = activeStreams;
    }

    public boolean isEmpty() {
        return this.getCurrentPipelines().isEmpty();
    }

    public ImmutableSet<String> getDestinations() {
        return this.destinations;
    }

    public ImmutableSet<String> getActiveStreams() {
        return this.activeStreams;
    }

    public Set<Pipeline> getPipelinesForMessage(Message msg) {
        return msg.getStreamIds().stream().map(id -> (Pipeline)this.getCurrentPipelines().get(id)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    protected String getStageCacheMetricName() {
        return MetricRegistry.name(PipelineRuleOutputFilter.class, (String[])new String[]{"stage-cache"});
    }

    public static interface Factory {
        public PipelineRuleOutputFilterState newState(@Assisted(value="pipelines") ImmutableMap<String, Pipeline> var1, @Assisted(value="destinations") ImmutableSet<String> var2, @Assisted(value="activeStreams") ImmutableSet<String> var3);
    }
}

