/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import com.google.common.base.Stopwatch;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import javax.annotation.Nonnull;
import org.graylog2.Configuration;
import org.graylog2.cluster.NodeService;
import org.graylog2.cluster.leader.LeaderElectionMode;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.periodical.Periodical;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LeaderPresenceCheckPeriodical
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderPresenceCheckPeriodical.class);
    private final Configuration configuration;
    private final NodeService nodeService;
    private final NotificationService notificationService;
    private final ActivityWriter activityWriter;
    private final ServerStatus serverStatus;
    private final Stopwatch timeWithoutLeader;

    @Inject
    public LeaderPresenceCheckPeriodical(Configuration configuration, NodeService nodeService, NotificationService notificationService, ActivityWriter activityWriter, ServerStatus serverStatus) {
        this.configuration = configuration;
        this.nodeService = nodeService;
        this.notificationService = notificationService;
        this.activityWriter = activityWriter;
        this.serverStatus = serverStatus;
        this.timeWithoutLeader = Stopwatch.createUnstarted();
    }

    @Override
    public void doRun() {
        try {
            boolean anyLeaderPresent = this.nodeService.isAnyLeaderPresent();
            if (anyLeaderPresent) {
                if (this.timeWithoutLeader.isRunning()) {
                    this.timeWithoutLeader.reset();
                }
                if (this.fixNoLeaderNotification()) {
                    this.activityWriter.write(new Activity("Notification condition [" + String.valueOf((Object)Notification.Type.NO_LEADER) + "] has been fixed.", LeaderPresenceCheckPeriodical.class));
                }
            } else {
                if (!this.timeWithoutLeader.isRunning()) {
                    this.timeWithoutLeader.start();
                }
                this.getLogger().debug("No leader node found. Elapsed time without leader node: {}", (Object)this.timeWithoutLeader);
                if (this.shouldWarnForNoLeader()) {
                    Notification notification = this.notificationService.buildNow().addNode(this.serverStatus.getNodeId().toString()).addType(Notification.Type.NO_LEADER).addSeverity(Notification.Severity.URGENT);
                    this.notificationService.publishIfFirst(notification);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Caught exception during check for presence of leader node.", (Throwable)e);
        }
    }

    private boolean shouldWarnForNoLeader() {
        if (this.configuration.getLeaderElectionMode() != LeaderElectionMode.AUTOMATIC) {
            return true;
        }
        Duration gracePeriod = this.configuration.getLeaderElectionLockPollingInterval().plusSeconds(1L);
        return this.timeWithoutLeader.elapsed().compareTo(gracePeriod) > 0;
    }

    private boolean fixNoLeaderNotification() {
        return this.notificationService.fixed(this.notificationService.build().addType(Notification.Type.NO_MASTER)) | this.notificationService.fixed(this.notificationService.build().addType(Notification.Type.NO_LEADER));
    }

    @Override
    @Nonnull
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean leaderOnly() {
        return false;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 5;
    }
}

