/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.periodical;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import javax.annotation.Nonnull;
import org.graylog2.cluster.leader.LeaderElectionService;
import org.graylog2.cluster.nodes.NodeService;
import org.graylog2.cluster.nodes.ServerNodeDto;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NodePingThread
extends Periodical {
    private static final Logger LOG = LoggerFactory.getLogger(NodePingThread.class);
    private final NodeService<ServerNodeDto> nodeService;
    private final HttpConfiguration httpConfiguration;
    private final ServerStatus serverStatus;
    private final LeaderElectionService leaderElectionService;

    @Inject
    public NodePingThread(NodeService<ServerNodeDto> nodeService, HttpConfiguration httpConfiguration, ServerStatus serverStatus, LeaderElectionService leaderElectionService) {
        this.nodeService = nodeService;
        this.httpConfiguration = httpConfiguration;
        this.serverStatus = serverStatus;
        this.leaderElectionService = leaderElectionService;
    }

    @Override
    public synchronized void doRun() {
        boolean isLeader = this.leaderElectionService.isLeader();
        ServerNodeDto dto = ((ServerNodeDto.Builder)((ServerNodeDto.Builder)((ServerNodeDto.Builder)((ServerNodeDto.Builder)ServerNodeDto.Builder.builder().setId(this.serverStatus.getNodeId().getNodeId())).setLeader(isLeader)).setTransportAddress(this.httpConfiguration.getHttpPublishUri().resolve("api/").toString())).setHostname(Tools.getLocalCanonicalHostname())).build();
        this.nodeService.ping(dto);
    }

    @Override
    @Nonnull
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public boolean runsForever() {
        return false;
    }

    @Override
    public boolean stopOnGracefulShutdown() {
        return false;
    }

    @Override
    public boolean leaderOnly() {
        return false;
    }

    @Override
    public boolean startOnThisNode() {
        return true;
    }

    @Override
    public boolean isDaemon() {
        return true;
    }

    @Override
    public int getInitialDelaySeconds() {
        return 0;
    }

    @Override
    public int getPeriodSeconds() {
        return 1;
    }
}

