/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.eventbus.EventBus;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Objects;
import org.graylog2.plugin.Stoppable;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.events.inputs.IOStateChangedEvent;
import org.joda.time.DateTime;

@JsonAutoDetect
public class IOState<T extends Stoppable> {
    protected T stoppable;
    private EventBus eventbus;
    protected Type state;
    protected DateTime startedAt;
    protected String detailedMessage;

    @AssistedInject
    public IOState(EventBus eventbus, @Assisted T stoppable) {
        this(eventbus, stoppable, Type.CREATED);
    }

    @AssistedInject
    public IOState(EventBus eventbus, @Assisted T stoppable, @Assisted Type state) {
        this.eventbus = eventbus;
        this.state = state;
        this.stoppable = stoppable;
        this.startedAt = Tools.nowUTC();
    }

    public T getStoppable() {
        return this.stoppable;
    }

    public void setStoppable(T stoppable) {
        this.stoppable = stoppable;
    }

    public Type getState() {
        return this.state;
    }

    public boolean canBeStarted() {
        switch (this.getState()) {
            case RUNNING: 
            case STARTING: {
                return false;
            }
        }
        return true;
    }

    public void setState(Type state, String detailedMessage) {
        this.setDetailedMessage(detailedMessage);
        if (this.state == state) {
            return;
        }
        IOStateChangedEvent evt = IOStateChangedEvent.create(this.state, state, this);
        this.state = state;
        this.eventbus.post(evt);
    }

    public void setState(Type state) {
        this.setState(state, null);
    }

    public DateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(DateTime startedAt) {
        this.startedAt = startedAt;
    }

    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    public void setDetailedMessage(String detailedMessage) {
        this.detailedMessage = detailedMessage;
    }

    public String toString() {
        return "InputState{stoppable=" + String.valueOf(this.stoppable) + ", state=" + String.valueOf((Object)this.state) + ", startedAt=" + String.valueOf(this.startedAt) + ", detailedMessage='" + this.detailedMessage + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOState that = (IOState)o;
        return Objects.equals(this.stoppable, that.stoppable);
    }

    public int hashCode() {
        return Objects.hash(this.stoppable);
    }

    public static enum Type {
        CREATED,
        INITIALIZED,
        INVALID_CONFIGURATION,
        STARTING,
        RUNNING,
        FAILED,
        STOPPING,
        STOPPED,
        TERMINATED,
        FAILING,
        UNRECOGNIZED;

    }

    public static interface Factory<T extends Stoppable> {
        public IOState<T> create(T var1);

        public IOState<T> create(T var1, Type var2);
    }
}

