/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.datanodes;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.DataNodePaginatedService;
import org.graylog2.database.PaginatedList;
import org.graylog2.rest.models.SortOrder;
import org.graylog2.rest.models.tools.responses.PageListResponse;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.rest.resources.entities.EntityDefaults;
import org.graylog2.rest.resources.entities.Sorting;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="System/Datanodes", description="Data Node discovery")
@RequiresAuthentication
@Path(value="/system/cluster/datanodes")
@Produces(value={"application/json"})
public class DatanodeResource
extends RestResource {
    private final DataNodePaginatedService dataNodePaginatedService;
    private final SearchQueryParser searchQueryParser;
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"id", (Object)SearchQueryField.create("_id", SearchQueryField.Type.OBJECT_ID)).put((Object)"hostname", (Object)SearchQueryField.create("hostname")).put((Object)"datanode_status", (Object)SearchQueryField.create("datanode_status")).build();
    private static final String DEFAULT_SORT_FIELD = "title";
    private static final String DEFAULT_SORT_DIRECTION = "asc";
    private static final List<EntityAttribute> attributes = List.of(EntityAttribute.builder().id("hostname").title("Name").build(), EntityAttribute.builder().id("data_node_status").title("Status").build(), EntityAttribute.builder().id("transport_address").title("Transport address").build(), EntityAttribute.builder().id("cert_valid_until").title("Certificate valid until").build(), EntityAttribute.builder().id("datanode_version").title("Datanode version").build());
    private static final EntityDefaults settings = EntityDefaults.builder().sort(Sorting.create("title", Sorting.Direction.valueOf("asc".toUpperCase(Locale.ROOT)))).build();

    @Inject
    public DatanodeResource(DataNodePaginatedService dataNodePaginatedService) {
        this.dataNodePaginatedService = dataNodePaginatedService;
        this.searchQueryParser = new SearchQueryParser("hostname", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @GET
    @Timed
    @ApiOperation(value="Get a paginated list of all datanodes in this cluster")
    public PageListResponse<DataNodeDto> dataNodes(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title,description,type") @DefaultValue(value="title") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") SortOrder order) {
        SearchQuery searchQuery = this.searchQueryParser.parse(query);
        PaginatedList<DataNodeDto> result = this.dataNodePaginatedService.searchPaginated(searchQuery, order.toBsonSort(sort), page, perPage);
        return PageListResponse.create(query, result.pagination(), (long)result.grandTotal().orElse(0L), sort, order, result.stream().toList(), attributes, settings);
    }
}

