/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.debug;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.streams.StreamRouter;

@RequiresAuthentication
@Api(value="System/Debug/Streams", description="For debugging local and cluster events.")
@Path(value="/system/debug/streams")
@Produces(value={"application/json"})
public class DebugStreamsResource
extends RestResource {
    private final StreamRouter streamRouter;

    @Inject
    public DebugStreamsResource(StreamRouter streamRouter) {
        this.streamRouter = streamRouter;
    }

    @GET
    @Path(value="/router_engine_info")
    @ApiOperation(value="Get information about currently active stream router engine.")
    @Produces(value={"application/json"})
    public Response getEngineFingerprint() {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.streamRouter.getRouterEngineInfo()).build();
    }
}

