/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system.indexer;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.PermittedStreams;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesListService;
import org.graylog2.indexer.indexset.IndexSetFieldTypeSummaryService;
import org.graylog2.rest.models.tools.responses.PageListResponse;
import org.graylog2.rest.resources.entities.Sorting;
import org.graylog2.rest.resources.system.indexer.requests.FieldTypeSummaryRequest;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetFieldType;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetFieldTypeSummary;
import org.graylog2.rest.resources.system.indexer.responses.IndexSetIdAndType;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="System/IndexSets/Types", description="Index set field types", tags={"cloud"})
@Path(value="/system/indices/index_sets/types")
@Produces(value={"application/json"})
public class IndexSetsMappingResource
extends RestResource {
    private final IndexSetFieldTypeSummaryService indexSetFieldTypeSummaryService;
    private final PermittedStreams permittedStreams;
    private final IndexFieldTypesListService indexFieldTypesListService;

    @Inject
    public IndexSetsMappingResource(IndexSetFieldTypeSummaryService indexSetFieldTypeSummaryService, IndexFieldTypesListService indexFieldTypesListService, PermittedStreams permittedStreams) {
        this.indexSetFieldTypeSummaryService = indexSetFieldTypeSummaryService;
        this.indexFieldTypesListService = indexFieldTypesListService;
        this.permittedStreams = permittedStreams;
    }

    @GET
    @Path(value="/{index_set_id}")
    @Timed
    @NoAuditEvent(value="No change to the DB")
    @ApiOperation(value="Gets list of field_name-field_type pairs for given index set, paginated")
    public PageListResponse<IndexSetFieldType> indexSetFieldTypesList(@ApiParam(name="index_set_id") @PathParam(value="index_set_id") String indexSetId, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="filters") @QueryParam(value="filters") List<String> filters, @ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="field_name,type,origin,is_reserved") @DefaultValue(value="field_name") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc,desc") @DefaultValue(value="asc") @QueryParam(value="order") String order, @Context SearchUser searchUser) {
        this.checkPermission("indexsets:read", indexSetId);
        return this.indexFieldTypesListService.getIndexSetFieldTypesListPage(indexSetId, query, filters, page, perPage, sort, Sorting.Direction.valueOf(order.toUpperCase(Locale.ROOT)));
    }

    @GET
    @Path(value="/{index_set_id}/all")
    @Timed
    @NoAuditEvent(value="No change to the DB")
    @ApiOperation(value="Gets list of all field_name-field_type pairs for given index set")
    public List<IndexSetFieldType> indexSetFieldTypesList(@ApiParam(name="index_set_id") @PathParam(value="index_set_id") String indexSetId, @ApiParam(name="fieldNameQuery") @QueryParam(value="fieldNameQuery") @DefaultValue(value="") String fieldNameQuery, @ApiParam(name="filters") @QueryParam(value="filters") List<String> filters, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="field_name,type,origin,is_reserved") @DefaultValue(value="field_name") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc,desc") @DefaultValue(value="asc") @QueryParam(value="order") String order, @Context SearchUser searchUser) {
        this.checkPermission("indexsets:read", indexSetId);
        return this.indexFieldTypesListService.getIndexSetFieldTypesList(indexSetId, fieldNameQuery, filters, sort, Sorting.Direction.valueOf(order.toUpperCase(Locale.ROOT)));
    }

    @POST
    @Timed
    @NoAuditEvent(value="No change to the DB")
    @ApiOperation(value="Get field type summaries for given index sets and field")
    public PageListResponse<IndexSetFieldTypeSummary> fieldTypeSummaries(@ApiParam(name="JSON body", required=true) @Valid @NotNull FieldTypeSummaryRequest request, @ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="index_set_id,index_set_title") @DefaultValue(value="index_set_id") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc,desc") @DefaultValue(value="asc") @QueryParam(value="order") String order, @Context SearchUser searchUser) {
        Set<String> streamsIds = this.normalizeStreamIds(request.streamsIds(), searchUser);
        String fieldName = request.fieldName();
        return this.indexSetFieldTypeSummaryService.getIndexSetFieldTypeSummary(streamsIds, fieldName, indexSetId -> this.isPermitted("indexsets:read", (String)indexSetId), page, perPage, sort, Sorting.Direction.valueOf(order.toUpperCase(Locale.ROOT)));
    }

    @POST
    @Path(value="/index_sets_with_field_type_change_support")
    @Timed
    @NoAuditEvent(value="No change to the DB")
    @ApiOperation(value="Get field type summaries for given index sets and field")
    public List<IndexSetIdAndType> indexSetsWithFieldTypeChangeSupport(@ApiParam(name="Stream ids", required=true) Set<String> streamIds, @Context SearchUser searchUser) {
        Set<String> streamsIds = this.normalizeStreamIds(streamIds, searchUser);
        return this.indexSetFieldTypeSummaryService.getIdsAndTypesOfIndexSetsWhereFieldTypeChangeIsAllowed(streamsIds, indexSetId -> this.isPermitted("indexsets:read", (String)indexSetId));
    }

    private Set<String> normalizeStreamIds(Set<String> streams, SearchUser searchUser) {
        return streams == null || streams.isEmpty() ? this.permittedStreams.loadAllMessageStreams(searchUser) : streams;
    }
}

