/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.search;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog2.search.SearchQueryParser;
import org.mongojack.DBQuery;

public class SearchQuery {
    private final Multimap<String, SearchQueryParser.FieldValue> queryMap;
    private final Set<String> disallowedKeys;
    private final String queryString;

    public SearchQuery(String queryString) {
        this(queryString, (Multimap<String, SearchQueryParser.FieldValue>)HashMultimap.create(), Collections.emptySet());
    }

    public SearchQuery(String queryString, Multimap<String, SearchQueryParser.FieldValue> queryMap, Set<String> disallowedKeys) {
        this.queryString = queryString;
        this.queryMap = queryMap;
        this.disallowedKeys = disallowedKeys;
    }

    public Multimap<String, SearchQueryParser.FieldValue> getQueryMap() {
        return this.queryMap;
    }

    public DBQuery.Query toDBQuery() {
        if (this.queryMap.isEmpty()) {
            return DBQuery.empty();
        }
        ArrayList<DBQuery.Query> dbQueries = new ArrayList<DBQuery.Query>();
        for (Map.Entry entry : this.queryMap.asMap().entrySet()) {
            ArrayList<DBQuery.Query> queries = new ArrayList<DBQuery.Query>();
            List<SearchQueryParser.FieldValue> include = this.selectValues((Collection)entry.getValue(), value -> !value.isNegate());
            List<SearchQueryParser.FieldValue> exclude = this.selectValues((Collection)entry.getValue(), SearchQueryParser.FieldValue::isNegate);
            if (!include.isEmpty()) {
                queries.add(DBQuery.or((DBQuery.Query[])this.toQuery((String)entry.getKey(), include)));
            }
            if (!exclude.isEmpty()) {
                queries.add(DBQuery.nor((DBQuery.Query[])this.toQuery((String)entry.getKey(), exclude)));
            }
            dbQueries.add(DBQuery.and((DBQuery.Query[])queries.toArray(new DBQuery.Query[0])));
        }
        return DBQuery.and((DBQuery.Query[])dbQueries.toArray(new DBQuery.Query[0]));
    }

    private DBQuery.Query[] toQuery(String field, List<SearchQueryParser.FieldValue> values) {
        return (DBQuery.Query[])values.stream().map(value -> value.getOperator().buildQuery(field, value.getValue())).toArray(DBQuery.Query[]::new);
    }

    public Bson toBson() {
        if (this.queryMap.isEmpty()) {
            return new Document();
        }
        List<Bson> dbQueries = this.toBsonFilterList();
        return Filters.and(dbQueries);
    }

    public List<Bson> toBsonFilterList() {
        if (this.queryMap.isEmpty()) {
            return List.of();
        }
        ArrayList<Bson> dbQueries = new ArrayList<Bson>();
        for (Map.Entry entry : this.queryMap.asMap().entrySet()) {
            ArrayList<Bson> queries = new ArrayList<Bson>();
            List<SearchQueryParser.FieldValue> include = this.selectValues((Collection)entry.getValue(), value -> !value.isNegate());
            List<SearchQueryParser.FieldValue> exclude = this.selectValues((Collection)entry.getValue(), SearchQueryParser.FieldValue::isNegate);
            if (!include.isEmpty()) {
                queries.add(Filters.or(this.toBson((String)entry.getKey(), include)));
            }
            if (!exclude.isEmpty()) {
                queries.add(Filters.nor(this.toBson((String)entry.getKey(), exclude)));
            }
            dbQueries.add(Filters.and(queries));
        }
        return dbQueries;
    }

    private List<Bson> toBson(String field, List<SearchQueryParser.FieldValue> values) {
        return values.stream().map(value -> value.getOperator().buildBson(field, value.getValue())).toList();
    }

    private List<SearchQueryParser.FieldValue> selectValues(Collection<SearchQueryParser.FieldValue> values, Function<SearchQueryParser.FieldValue, Boolean> callback) {
        return values.stream().filter(callback::apply).toList();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Set<String> getDisallowedKeys() {
        return this.disallowedKeys;
    }

    public boolean hasDisallowedKeys() {
        return !this.disallowedKeys.isEmpty();
    }
}

