/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import jakarta.annotation.Nonnull;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.graylog.security.certutil.csr.FilesystemKeystoreInformation;
import org.graylog.security.certutil.csr.KeystoreInformation;
import org.graylog2.security.TruststoreUtils;

public class TruststoreCreator {
    private final KeyStore truststore;

    public TruststoreCreator(KeyStore truststore) {
        this.truststore = truststore;
    }

    public static TruststoreCreator newDefaultJvm() {
        return TruststoreUtils.loadJvmTruststore().map(TruststoreCreator::new).orElseGet(TruststoreCreator::newEmpty);
    }

    public static TruststoreCreator newEmpty() {
        try {
            KeyStore trustStore = KeyStore.getInstance("PKCS12");
            trustStore.load(null, null);
            return new TruststoreCreator(trustStore);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public TruststoreCreator addFromKeystore(KeystoreInformation keystoreInformation, String alias) throws IOException, GeneralSecurityException {
        KeyStore keystore = keystoreInformation.loadKeystore();
        Certificate[] chain = keystore.getCertificateChain(alias);
        List<X509Certificate> x509Certs = TruststoreCreator.toX509Certs(chain);
        return this.addCertificates(x509Certs);
    }

    @Nonnull
    private static List<X509Certificate> toX509Certs(Certificate[] certs) {
        return Arrays.stream(certs).filter(c -> c instanceof X509Certificate).map(c -> (X509Certificate)c).toList();
    }

    public TruststoreCreator addCertificates(List<X509Certificate> trustedCertificates) {
        trustedCertificates.forEach(cert -> {
            try {
                this.truststore.setCertificateEntry(TruststoreCreator.generateAlias(this.truststore, cert), (Certificate)cert);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        });
        return this;
    }

    private static String generateAlias(KeyStore truststore, X509Certificate cert) throws KeyStoreException {
        AtomicInteger counter = new AtomicInteger(1);
        String cname = cert.getSubjectX500Principal().getName();
        Object alias = cname;
        while (truststore.containsAlias((String)alias)) {
            alias = cname + "_" + counter.getAndIncrement();
        }
        return alias;
    }

    public FilesystemKeystoreInformation persist(Path truststorePath, char[] truststorePassword) throws IOException, GeneralSecurityException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(truststorePath.toFile());){
            this.truststore.store(fileOutputStream, truststorePassword);
        }
        return new FilesystemKeystoreInformation(truststorePath, truststorePassword);
    }

    @Nonnull
    public KeyStore getTruststore() {
        return this.truststore;
    }
}

