/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.encryption;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.security.GeneralSecurityException;
import javax.annotation.Nullable;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.graylog2.security.AESTools;
import org.graylog2.security.encryption.EncryptedValue;

@Singleton
public class EncryptedValueService {
    private final String encryptionKey;

    @Inject
    public EncryptedValueService(@Named(value="password_secret") String passwordSecret) {
        String trimmedPasswordSecret = passwordSecret.trim();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)trimmedPasswordSecret) ? 1 : 0) != 0, (Object)"password secret cannot be null or empty");
        Preconditions.checkArgument((trimmedPasswordSecret.length() >= 16 ? 1 : 0) != 0, (Object)"password secret must be at least 16 characters long");
        this.encryptionKey = trimmedPasswordSecret;
    }

    public EncryptedValue encrypt(String plainValue) {
        String salt = AESTools.generateNewSalt();
        return EncryptedValue.builder().value(AESTools.encrypt(plainValue, this.encryptionKey, salt)).salt(salt).isKeepValue(false).isDeleteValue(false).build();
    }

    @Nullable
    public String decrypt(EncryptedValue encryptedValue) {
        if (!encryptedValue.isSet()) {
            return null;
        }
        return AESTools.decrypt(encryptedValue.value(), this.encryptionKey, encryptedValue.salt());
    }

    public String tryDecrypt(EncryptedValue encryptedValue) throws InvalidCipherTextException, GeneralSecurityException {
        if (!encryptedValue.isSet()) {
            throw new IllegalArgumentException("Encrypted value is not set!");
        }
        return AESTools.tryDecrypt(encryptedValue.value(), this.encryptionKey, encryptedValue.salt());
    }
}

