/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.hashing;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.regex.Pattern;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.graylog2.plugin.security.PasswordAlgorithm;

public class SHA1HashPasswordAlgorithm
implements PasswordAlgorithm {
    private static final String HASH_ALGORITHM = "SHA-1";
    private static final Pattern prefixPattern = Pattern.compile("^[a-f0-9]{40}$");
    private final String passwordSecret;

    @Inject
    public SHA1HashPasswordAlgorithm(@Named(value="password_secret") String passwordSecret) {
        this.passwordSecret = passwordSecret;
    }

    @Override
    public boolean supports(String hashedPassword) {
        return prefixPattern.matcher(hashedPassword).matches();
    }

    private String hash(String password, String salt) {
        return new SimpleHash(HASH_ALGORITHM, (Object)password, (Object)salt).toString();
    }

    @Override
    public String hash(String password) {
        return this.hash(password, this.passwordSecret);
    }

    @Override
    public boolean matches(String hashedPassword, String otherPassword) {
        if (this.supports(hashedPassword)) {
            return this.hash(otherPassword).equals(hashedPassword);
        }
        throw new IllegalArgumentException("Supplied hashed password is not supported.");
    }
}

