/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.untrusted;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509TrustManager;
import org.graylog2.security.untrusted.CertificateReportingException;

public class CertificateChainReportingTrustManager
implements X509TrustManager {
    private final X509TrustManager delegate;

    public CertificateChainReportingTrustManager(X509TrustManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.delegate.checkClientTrusted(chain, authType);
        }
        catch (CertificateException e) {
            throw new CertificateReportingException(e, chain);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.delegate.checkServerTrusted(chain, authType);
        }
        catch (CertificateException e) {
            throw new CertificateReportingException(e, chain);
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }
}

