/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security.untrusted;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.graylog2.security.untrusted.CertificateChainReportingTrustManager;
import org.graylog2.security.untrusted.CertificateReportingException;

public class UntrustedCertificateExtractor {
    private final OkHttpClient httpClient;

    public UntrustedCertificateExtractor(OkHttpClient okHttpClient) {
        this.httpClient = okHttpClient;
    }

    public List<X509Certificate> extractUntrustedCerts(String host) throws NoSuchAlgorithmException, IOException, KeyManagementException {
        block3: {
            SSLContext ctx = SSLContext.getInstance("TLS");
            CertificateChainReportingTrustManager trustManager = new CertificateChainReportingTrustManager(this.httpClient.x509TrustManager());
            ctx.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            OkHttpClient reportingClient = this.httpClient.newBuilder().sslSocketFactory(ctx.getSocketFactory(), (X509TrustManager)trustManager).build();
            Request req = new Request.Builder().get().url(host).build();
            try {
                Response ignored = reportingClient.newCall(req).execute();
                if (ignored != null) {
                    ignored.close();
                }
            }
            catch (SSLHandshakeException e) {
                Throwable throwable = e.getCause();
                if (!(throwable instanceof CertificateReportingException)) break block3;
                CertificateReportingException certificateReportingException = (CertificateReportingException)throwable;
                return Arrays.asList(certificateReportingException.getChain());
            }
        }
        return Collections.emptyList();
    }
}

