/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.initializers;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractIdleService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.graylog2.cluster.leader.LeaderChangedEvent;
import org.graylog2.cluster.leader.LeaderElectionService;
import org.graylog2.periodical.Periodicals;
import org.graylog2.plugin.periodical.Periodical;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PeriodicalsService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicalsService.class);
    private final Periodicals periodicals;
    private final Set<Periodical> allPeriodicals;
    private final EventBus eventBus;
    private final LeaderElectionService leaderElectionService;
    private final Set<Periodical> leaderNodePeriodicals = new HashSet<Periodical>();
    private final Set<Periodical> anyNodePeriodicals = new HashSet<Periodical>();

    @Inject
    public PeriodicalsService(Periodicals periodicals, Set<Periodical> allPeriodicals, EventBus eventBus, LeaderElectionService leaderElectionService) {
        this.periodicals = periodicals;
        this.allPeriodicals = allPeriodicals;
        this.eventBus = eventBus;
        this.leaderElectionService = leaderElectionService;
        allPeriodicals.forEach(p -> {
            if (p.leaderOnly()) {
                this.leaderNodePeriodicals.add((Periodical)p);
            } else {
                this.anyNodePeriodicals.add((Periodical)p);
            }
        });
    }

    protected void startUp() throws Exception {
        this.eventBus.register((Object)this);
        if (this.leaderElectionService.isLeader()) {
            LOG.info("Starting {} periodicals ...", (Object)this.allPeriodicals.size());
            this.startPeriodicals(this.allPeriodicals);
        } else {
            LOG.info("Starting {} periodicals ...", (Object)this.anyNodePeriodicals.size());
            LOG.info("Delaying start of {} periodicals until this node becomes leader ...", (Object)this.leaderNodePeriodicals.size());
            this.startPeriodicals(this.anyNodePeriodicals);
        }
    }

    @Subscribe
    public void leaderChanged(LeaderChangedEvent leaderChangedEvent) {
        if (this.leaderElectionService.isLeader()) {
            LOG.info("Starting {} periodicals ...", (Object)this.leaderNodePeriodicals.size());
            this.startPeriodicals(this.leaderNodePeriodicals);
        } else {
            Sets.SetView runningLeaderNodePeriodicals = Sets.intersection(this.leaderNodePeriodicals, this.periodicals.getAllRunning());
            LOG.info("Stopping {} periodicals ...", (Object)runningLeaderNodePeriodicals);
            this.stopPeriodicals((Collection<Periodical>)runningLeaderNodePeriodicals);
        }
    }

    private synchronized void startPeriodicals(Set<Periodical> periodicalsToStart) {
        Sets.SetView notYetStartedPeriodicals = Sets.difference(periodicalsToStart, (Set)ImmutableSet.copyOf(this.periodicals.getAll()));
        int numOfPeriodicalsToSkip = periodicalsToStart.size() - notYetStartedPeriodicals.size();
        if (numOfPeriodicalsToSkip > 0) {
            LOG.warn("Skipping start of {} periodicals which have already been started.", (Object)numOfPeriodicalsToSkip);
        }
        for (Periodical periodical : notYetStartedPeriodicals) {
            try {
                periodical.initialize();
                if (!periodical.startOnThisNode()) {
                    LOG.info("Not starting [{}] periodical. Not configured to run on this node.", (Object)periodical.getClass().getCanonicalName());
                    continue;
                }
                this.periodicals.registerAndStart(periodical);
            }
            catch (Exception e) {
                LOG.error("Could not initialize periodical.", (Throwable)e);
            }
        }
    }

    private synchronized void stopPeriodicals(Collection<Periodical> periodicalsToStop) {
        periodicalsToStop.forEach(this.periodicals::unregisterAndStop);
    }

    protected void shutDown() throws Exception {
        this.eventBus.unregister((Object)this);
        this.stopPeriodicals(this.periodicals.getAllStoppedOnGracefulShutdown());
    }
}

