/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.messageq;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.google.auto.value.AutoValue;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.List;
import org.graylog2.shared.buffers.RawMessageEvent;
import org.graylog2.shared.messageq.AutoValue_MessageQueueWriter_Metrics;
import org.graylog2.shared.messageq.MessageQueueException;

public interface MessageQueueWriter {
    public void write(List<RawMessageEvent> var1) throws MessageQueueException;

    @AutoValue
    public static abstract class Metrics {
        public abstract Meter writtenMessages();

        public abstract Meter writtenBytes();

        public abstract Meter failedWriteAttempts();

        public static Builder builder() {
            return new AutoValue_MessageQueueWriter_Metrics.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder writtenMessages(Meter var1);

            public abstract Builder writtenBytes(Meter var1);

            public abstract Builder failedWriteAttempts(Meter var1);

            public abstract Metrics build();
        }

        public static class Provider
        implements jakarta.inject.Provider<Metrics> {
            private final MetricRegistry metricRegistry;

            @Inject
            public Provider(MetricRegistry metricRegistry) {
                this.metricRegistry = metricRegistry;
            }

            public Metrics get() {
                return Metrics.builder().writtenMessages(this.metricRegistry.meter(MetricRegistry.name(MessageQueueWriter.class, (String[])new String[]{"written-messages"}))).writtenBytes(this.metricRegistry.meter(MetricRegistry.name(MessageQueueWriter.class, (String[])new String[]{"written-bytes"}))).failedWriteAttempts(this.metricRegistry.meter(MetricRegistry.name(MessageQueueWriter.class, (String[])new String[]{"failed-write-attempts"}))).build();
            }
        }
    }
}

