/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import jakarta.inject.Inject;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.AllPermission;
import org.apache.shiro.subject.Subject;
import org.bson.Document;
import org.graylog2.database.dbcatalog.DbEntitiesCatalog;
import org.graylog2.database.dbcatalog.DbEntityCatalogEntry;

public class EntityPermissionsUtils {
    public static final String ID_FIELD = "_id";
    private final DbEntitiesCatalog catalog;

    @Inject
    public EntityPermissionsUtils(DbEntitiesCatalog catalog) {
        this.catalog = catalog;
    }

    public Predicate<Document> createPermissionCheck(Subject subject, String collection) {
        Optional<String> readPermission = this.readPermissionForCollection(collection);
        return doc -> readPermission.map(permission -> subject.isPermitted(permission + ":" + doc.getObjectId((Object)ID_FIELD).toString())).orElse(false);
    }

    public boolean hasAllPermission(Subject subject) {
        return subject.isPermitted((Permission)new AllPermission());
    }

    public boolean hasReadPermissionForWholeCollection(Subject subject, String collection) {
        return this.readPermissionForCollection(collection).map(rp -> rp.equals("") || subject.isPermitted(rp + ":*")).orElse(false);
    }

    public Optional<String> readPermissionForCollection(String collection) {
        return this.catalog.getByCollectionName(collection).map(DbEntityCatalogEntry::readPermission);
    }
}

