/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.storage.versionprobe;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.joschi.jadconfig.util.Duration;
import com.github.rholder.retry.Attempt;
import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.RetryListener;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.github.zafarkhaja.semver.Version;
import com.google.common.base.Strings;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import org.graylog2.configuration.RunsWithDataNode;
import org.graylog2.security.IndexerJwtAuthTokenProvider;
import org.graylog2.shared.utilities.ExceptionUtils;
import org.graylog2.storage.SearchVersion;
import org.graylog2.storage.versionprobe.ErrorResponse;
import org.graylog2.storage.versionprobe.RootResponse;
import org.graylog2.storage.versionprobe.RootRoute;
import org.graylog2.storage.versionprobe.VersionProbeListener;
import org.graylog2.storage.versionprobe.VersionProbeLogger;
import org.graylog2.storage.versionprobe.VersionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class VersionProbe {
    private static final Logger LOG = LoggerFactory.getLogger(VersionProbe.class);
    private final VersionProbeListener loggingListener = new VersionProbeLogger(LOG);
    private final ObjectMapper objectMapper;
    private final OkHttpClient okHttpClient;
    private final int connectionAttempts;
    private final Duration delayBetweenAttempts;
    private final boolean isJwtAuthentication;
    private final IndexerJwtAuthTokenProvider indexerJwtAuthTokenProvider;

    @Inject
    public VersionProbe(ObjectMapper objectMapper, OkHttpClient okHttpClient, @Named(value="elasticsearch_version_probe_attempts") int elasticsearchVersionProbeAttempts, @Named(value="elasticsearch_version_probe_delay") Duration elasticsearchVersionProbeDelay, @RunsWithDataNode Boolean runsWithDataNode, @Named(value="indexer_use_jwt_authentication") boolean opensearchUseJwtAuthentication, IndexerJwtAuthTokenProvider indexerJwtAuthTokenProvider) {
        this.objectMapper = objectMapper;
        this.okHttpClient = okHttpClient;
        this.connectionAttempts = elasticsearchVersionProbeAttempts;
        this.delayBetweenAttempts = elasticsearchVersionProbeDelay;
        this.isJwtAuthentication = runsWithDataNode != false || opensearchUseJwtAuthentication;
        this.indexerJwtAuthTokenProvider = indexerJwtAuthTokenProvider;
    }

    public Optional<SearchVersion> probe(Collection<URI> hosts) {
        return this.probe(hosts, this.loggingListener);
    }

    public Optional<SearchVersion> probe(Collection<URI> hosts, final VersionProbeListener probeListener) {
        try {
            return (Optional)RetryerBuilder.newBuilder().retryIfResult(input -> !input.isPresent()).retryIfExceptionOfType(IOException.class).retryIfRuntimeException().withRetryListener(new RetryListener(){

                public void onRetry(Attempt attempt) {
                    Object result;
                    if (attempt.hasResult() && (result = attempt.getResult()) instanceof Optional && ((Optional)result).isPresent()) {
                        return;
                    }
                    probeListener.onRetry(attempt.getAttemptNumber(), VersionProbe.this.connectionAttempts, VersionProbe.getAttemptException(attempt));
                }
            }).withWaitStrategy(WaitStrategies.fixedWait((long)this.delayBetweenAttempts.getQuantity(), (TimeUnit)this.delayBetweenAttempts.getUnit())).withStopStrategy(this.connectionAttempts == 0 ? StopStrategies.neverStop() : StopStrategies.stopAfterAttempt((int)this.connectionAttempts)).build().call(() -> this.probeAllHosts(hosts, probeListener));
        }
        catch (RetryException | ExecutionException e) {
            probeListener.onError("Unable to retrieve version from indexer node: ", e);
            return Optional.empty();
        }
    }

    @Nullable
    private static Throwable getAttemptException(Attempt attempt) {
        return Optional.of(attempt).filter(Attempt::hasException).map(Attempt::getExceptionCause).orElse(null);
    }

    private Optional<SearchVersion> probeAllHosts(Collection<URI> hosts, VersionProbeListener listener) {
        return hosts.stream().map(host -> this.probeSingleHost((URI)host, listener)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private Optional<SearchVersion> probeSingleHost(URI host, VersionProbeListener listener) {
        Retrofit retrofit;
        try {
            retrofit = new Retrofit.Builder().baseUrl(host.toURL()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)this.objectMapper)).client(this.addAuthenticationIfPresent(host, this.okHttpClient)).build();
        }
        catch (MalformedURLException e) {
            listener.onError("Indexer node URL is invalid: " + String.valueOf(host), e);
            return Optional.empty();
        }
        RootRoute root = (RootRoute)retrofit.create(RootRoute.class);
        Converter errorResponseConverter = retrofit.responseBodyConverter(ErrorResponse.class, new Annotation[0]);
        Consumer<ResponseBody> errorLogger = responseBody -> {
            try {
                ErrorResponse errorResponse = (ErrorResponse)errorResponseConverter.convert(responseBody);
                String message = String.format(Locale.ROOT, "Unable to retrieve version from indexer node %s:%s: %s", host.getHost(), host.getPort(), errorResponse);
                listener.onError(message, null);
            }
            catch (IOException e) {
                String message = String.format(Locale.ROOT, "Unable to retrieve version from indexer node %s:%s: unknown error - an exception occurred while deserializing error response: {}", host.getHost(), host.getPort());
                listener.onError(message, e);
            }
        };
        return this.rootResponse(root, errorLogger, listener).map(RootResponse::version).flatMap(versionResponse -> this.parseVersion((VersionResponse)versionResponse, listener));
    }

    private Optional<String> getAuthToken(URI host) {
        if (Strings.emptyToNull((String)host.getUserInfo()) != null) {
            String[] credentials = host.getUserInfo().split(":");
            String username = credentials[0];
            String password = credentials[1];
            return Optional.of(Credentials.basic((String)username, (String)password));
        }
        return Optional.empty();
    }

    private OkHttpClient addAuthenticationIfPresent(URI host, OkHttpClient okHttpClient) {
        Optional<String> authToken = this.getAuthToken(host);
        if (this.isJwtAuthentication || authToken.isPresent()) {
            return okHttpClient.newBuilder().addInterceptor(chain -> {
                Request originalRequest = chain.request();
                Request.Builder builder = originalRequest.newBuilder().header("Authorization", this.isJwtAuthentication ? this.indexerJwtAuthTokenProvider.get() : (String)authToken.get());
                Request newRequest = builder.build();
                return chain.proceed(newRequest);
            }).build();
        }
        return okHttpClient;
    }

    private Optional<SearchVersion> parseVersion(VersionResponse versionResponse, VersionProbeListener probeListener) {
        try {
            Version version = Version.parse((String)versionResponse.number());
            return Optional.of(SearchVersion.create(versionResponse.distribution(), version));
        }
        catch (Exception e) {
            probeListener.onError(String.format(Locale.ROOT, "Unable to parse version retrieved from indexer node: <%s>", versionResponse.number()), e);
            return Optional.empty();
        }
    }

    private Optional<RootResponse> rootResponse(RootRoute rootRoute, Consumer<ResponseBody> errorLogger, VersionProbeListener listener) {
        try {
            Response response = rootRoute.root().execute();
            if (response.isSuccessful()) {
                return Optional.ofNullable((RootResponse)response.body());
            }
            errorLogger.accept(response.errorBody());
        }
        catch (IOException e) {
            String error = ExceptionUtils.formatMessageCause(e);
            String rootCause = ExceptionUtils.formatMessageCause(ExceptionUtils.getRootCause(e));
            String message = String.format(Locale.ROOT, "Unable to retrieve version from indexer node: %s - %s", error, rootCause);
            listener.onError(message, null);
            LOG.debug("Complete exception for version probe error: ", (Throwable)e);
        }
        return Optional.empty();
    }
}

