/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.traffic;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bson.conversions.Bson;
import org.graylog2.database.MongoCollections;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.system.traffic.AutoValue_TrafficCounterService_TrafficHistogram;
import org.graylog2.system.traffic.TrafficDto;
import org.graylog2.system.traffic.TrafficUpdater;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficCounterService
implements TrafficUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(TrafficCounterService.class);
    private static final String BUCKET = "bucket";
    private static final String FIELD_DECODED = "decoded";
    private static final String FIELD_OUTPUT = "output";
    private static final String FIELD_INPUT = "input";
    private final MongoCollection<TrafficDto> collection;

    @Inject
    public TrafficCounterService(MongoCollections mongoCollections) {
        this.collection = mongoCollections.collection("traffic", TrafficDto.class);
        this.collection.createIndex(Indexes.ascending((String[])new String[]{BUCKET}), new IndexOptions().unique(true));
    }

    @Override
    public void updateTraffic(DateTime observationTime, NodeId nodeId, long inLastMinute, long outLastMinute, long decodedLastMinute) {
        DateTime dayBucket = TrafficUpdater.getHourBucketStart(observationTime);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updating traffic for node {} at {}:  in/decoded/out {}/{}/{} bytes", new Object[]{nodeId, dayBucket, inLastMinute, decodedLastMinute, outLastMinute});
        }
        String escapedNodeId = nodeId.toEscapedString();
        UpdateResult update = this.collection.updateOne(Filters.eq((String)BUCKET, (Object)dayBucket), Updates.combine((Bson[])new Bson[]{TrafficCounterService.incUpdate(FIELD_INPUT, escapedNodeId, inLastMinute), TrafficCounterService.incUpdate(FIELD_OUTPUT, escapedNodeId, outLastMinute), TrafficCounterService.incUpdate(FIELD_DECODED, escapedNodeId, decodedLastMinute)}), new UpdateOptions().upsert(true));
        if (!update.wasAcknowledged()) {
            LOG.warn("Unable to update traffic of node {} with bucket {}", (Object)nodeId, (Object)dayBucket);
        }
    }

    public static Bson incUpdate(String fieldInput, String escapedNodeId, long inLastMinute) {
        return Updates.inc((String)"%s.%s".formatted(fieldInput, escapedNodeId), (Number)inLastMinute);
    }

    public TrafficHistogram clusterTrafficOfLastDays(Duration daysToIncludeDuration, Interval interval) {
        return this.clusterTrafficOfLastDays(daysToIncludeDuration, interval, true);
    }

    public TrafficHistogram clusterTrafficOfLastDays(Duration daysToIncludeDuration, Interval interval, boolean includeToday) {
        TrafficHistograms trafficHistograms = TrafficCounterService.createTrafficHistograms(daysToIncludeDuration, includeToday);
        this.collection.find(TrafficCounterService.createQuery(trafficHistograms.getTo(), trafficHistograms.getFrom())).forEach(trafficDto -> {
            trafficHistograms.add(FIELD_INPUT, trafficDto.bucket(), TrafficCounterService.sumTraffic(trafficDto.input()));
            trafficHistograms.add(FIELD_OUTPUT, trafficDto.bucket(), TrafficCounterService.sumTraffic(trafficDto.output()));
            trafficHistograms.add(FIELD_DECODED, trafficDto.bucket(), TrafficCounterService.sumTraffic(trafficDto.decoded()));
        });
        if (interval == Interval.DAILY) {
            trafficHistograms.aggregateToDaily();
        }
        return TrafficHistogram.create(trafficHistograms.getFrom(), trafficHistograms.getTo(), trafficHistograms.getHistogramOrEmpty(FIELD_INPUT), trafficHistograms.getHistogramOrEmpty(FIELD_OUTPUT), trafficHistograms.getHistogramOrEmpty(FIELD_DECODED));
    }

    public static TrafficHistograms createTrafficHistograms(Duration daysToIncludeDuration, boolean includeToday) {
        DateTime now = Tools.nowUTC();
        DateTime to = includeToday ? now : TrafficUpdater.getDayBucketStart(now).minusMillis(1);
        DateTime from = TrafficUpdater.getDayBucketStart(now).minus((ReadableDuration)daysToIncludeDuration);
        return new TrafficHistograms(from, to);
    }

    public static Bson createQuery(DateTime to, DateTime from) {
        return Filters.and((Bson[])new Bson[]{Filters.lte((String)BUCKET, (Object)to), Filters.gte((String)BUCKET, (Object)from)});
    }

    public static long sumTraffic(Map<String, Long> sumTraffic) {
        return sumTraffic.values().stream().mapToLong(Long::valueOf).sum();
    }

    public static enum Interval {
        HOURLY,
        DAILY;

    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class TrafficHistogram {
        @JsonCreator
        public static TrafficHistogram create(@JsonProperty(value="from") DateTime from, @JsonProperty(value="to") DateTime to, @JsonProperty(value="input") Map<DateTime, Long> input, @JsonProperty(value="output") Map<DateTime, Long> output, @JsonProperty(value="decoded") Map<DateTime, Long> decoded) {
            return new AutoValue_TrafficCounterService_TrafficHistogram(from, to, input, output, decoded);
        }

        @JsonProperty
        public abstract DateTime from();

        @JsonProperty
        public abstract DateTime to();

        @JsonProperty
        public abstract Map<DateTime, Long> input();

        @JsonProperty
        public abstract Map<DateTime, Long> output();

        @JsonProperty
        public abstract Map<DateTime, Long> decoded();
    }

    public static class TrafficHistograms {
        private final Map<String, Map<DateTime, Long>> histograms = new HashMap<String, Map<DateTime, Long>>();
        private final DateTime from;
        private final DateTime to;

        public TrafficHistograms(DateTime from, DateTime to) {
            this.from = from;
            this.to = to;
        }

        public void add(String name, DateTime bucket, long value) {
            this.histograms.computeIfAbsent(name, k -> new HashMap()).put(bucket, value);
        }

        public Map<DateTime, Long> getHistogramOrEmpty(String name) {
            return this.histograms.computeIfAbsent(name, k -> new HashMap());
        }

        public long sumTraffic(String name) {
            return Optional.ofNullable(this.histograms.get(name)).map(traffic -> traffic.values().stream().mapToLong(Long::longValue).sum()).orElse(0L);
        }

        public void aggregateToDaily() {
            this.histograms.forEach((key, value) -> this.histograms.put((String)key, TrafficUpdater.aggregateToDaily(value)));
        }

        public DateTime getFrom() {
            return this.from;
        }

        public DateTime getTo() {
            return this.to;
        }
    }
}

