/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.urlwhitelist;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.AbstractIdleService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.graylog2.cluster.ClusterConfigChangedEvent;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.system.urlwhitelist.UrlWhitelist;
import org.graylog2.system.urlwhitelist.WhitelistEntry;

@Singleton
public class UrlWhitelistService
extends AbstractIdleService {
    private volatile UrlWhitelist cachedWhitelist = null;
    private final EventBus eventBus;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public UrlWhitelistService(EventBus eventBus, ClusterConfigService clusterConfigService) {
        this.eventBus = eventBus;
        this.clusterConfigService = clusterConfigService;
    }

    public UrlWhitelist getWhitelist() {
        UrlWhitelist whitelist = this.cachedWhitelist;
        if (whitelist == null) {
            this.cachedWhitelist = whitelist = this.clusterConfigService.getOrDefault(UrlWhitelist.class, UrlWhitelist.create(Collections.emptyList(), true));
        }
        return whitelist;
    }

    public void saveWhitelist(UrlWhitelist whitelist) {
        this.clusterConfigService.write(whitelist);
        this.cachedWhitelist = null;
    }

    public boolean isWhitelisted(String url) {
        return this.getWhitelist().isWhitelisted(url);
    }

    public Optional<WhitelistEntry> getEntry(String id) {
        return this.getWhitelist().entries().stream().filter(entry -> entry.id().equals(id)).findFirst();
    }

    public void addEntry(WhitelistEntry entry) {
        UrlWhitelist modified = this.addEntry(this.getWhitelist(), entry);
        this.saveWhitelist(modified);
    }

    public void removeEntry(String id) {
        UrlWhitelist modified = this.removeEntry(this.getWhitelist(), id);
        this.saveWhitelist(modified);
    }

    @Subscribe
    public void handleWhitelistUpdated(ClusterConfigChangedEvent event) {
        if (UrlWhitelist.class.getCanonicalName().equals(event.type())) {
            this.cachedWhitelist = null;
        }
    }

    protected void startUp() {
        this.eventBus.register((Object)this);
    }

    protected void shutDown() {
        this.eventBus.unregister((Object)this);
    }

    @VisibleForTesting
    UrlWhitelist addEntry(UrlWhitelist whitelist, WhitelistEntry entry) {
        LinkedHashMap entriesMap = whitelist.entries().stream().collect(Collectors.toMap(WhitelistEntry::id, Function.identity(), (a, b) -> {
            throw new IllegalStateException("Duplicate key '" + String.valueOf(a) + "'.");
        }, LinkedHashMap::new));
        entriesMap.put(entry.id(), entry);
        return whitelist.toBuilder().entries((List<WhitelistEntry>)ImmutableList.copyOf(entriesMap.values())).build();
    }

    @VisibleForTesting
    UrlWhitelist removeEntry(UrlWhitelist whitelist, String id) {
        List<WhitelistEntry> entries = whitelist.entries().stream().filter(entry -> !entry.id().equals(id)).collect(Collectors.toList());
        return whitelist.toBuilder().entries(entries).build();
    }
}

