/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.users;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.bson.conversions.Bson;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.search.SearchQuery;
import org.graylog2.users.UserOverviewDTO;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class PaginatedUserService
extends PaginatedDbService<UserOverviewDTO> {
    private static final String COLLECTION_NAME = "users";

    @Inject
    public PaginatedUserService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        super(mongoConnection, mapper, UserOverviewDTO.class, COLLECTION_NAME);
    }

    public long count() {
        return this.db.count();
    }

    public PaginatedList<UserOverviewDTO> findPaginated(SearchQuery searchQuery, int page, int perPage, String sortField, String order) {
        DBQuery.Query dbQuery = searchQuery.toDBQuery();
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        return this.findPaginatedWithQueryAndSort((Bson)dbQuery, (Bson)sortBuilder, page, perPage);
    }

    public PaginatedList<UserOverviewDTO> findPaginatedByUserId(SearchQuery searchQuery, int page, int perPage, String sortField, String order, Set<String> userIds) {
        DBQuery.Query dbQuery = (DBQuery.Query)searchQuery.toDBQuery().in("_id", userIds);
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        return this.findPaginatedWithQueryAndSort((Bson)dbQuery, (Bson)sortBuilder, page, perPage);
    }

    public PaginatedList<UserOverviewDTO> findPaginatedByRole(SearchQuery searchQuery, int page, int perPage, String sortField, String order, Set<String> roleIds) {
        DBQuery.Query dbQuery = (DBQuery.Query)searchQuery.toDBQuery().in("roles", roleIds);
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        return this.findPaginatedWithQueryAndSort((Bson)dbQuery, (Bson)sortBuilder, page, perPage);
    }

    public PaginatedList<UserOverviewDTO> findPaginatedByAuthServiceBackend(SearchQuery searchQuery, int page, int perPage, String sortField, String order, String authServiceBackendId) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)authServiceBackendId) ? 1 : 0) != 0, (Object)"authServiceBackendId cannot be blank");
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.is((String)"auth_service_id", Optional.of(authServiceBackendId)), searchQuery.toDBQuery()});
        return this.findPaginatedWithQueryAndSort((Bson)query, (Bson)this.getSortBuilder(order, sortField), page, perPage);
    }
}

