/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.jersey.container.netty;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.util.Base64;
import org.glassfish.jersey.message.internal.HttpDateFormat;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;
import org.graylog2.jersey.container.netty.DefaultSecurityContextFactory;
import org.graylog2.jersey.container.netty.HeaderAwareSecurityContext;
import org.graylog2.jersey.container.netty.SecurityContextFactory;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.DefaultExceptionEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.jboss.netty.handler.codec.http.DefaultHttpChunkTrailer;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyContainer
extends SimpleChannelUpstreamHandler
implements Container {
    private static final Logger log = LoggerFactory.getLogger(NettyContainer.class);
    public static final String PROPERTY_BASE_URI = "org.graylog2.jersey.container.netty.baseUri";
    public static final String REQUEST_PROPERTY_REMOTE_ADDR = "org.graylog2.jersey.container.netty.request.property.remote_addr";
    private final ApplicationHandler appHandler;
    private SecurityContextFactory securityContextFactory;
    private final URI baseUri;

    public NettyContainer(ApplicationHandler appHandler) {
        this(appHandler, null);
    }

    public NettyContainer(ApplicationHandler appHandler, SecurityContextFactory securityContextFactory) {
        this.appHandler = appHandler;
        this.securityContextFactory = securityContextFactory;
        this.baseUri = (URI)this.getConfiguration().getProperty(PROPERTY_BASE_URI);
    }

    public void setSecurityContextFactory(SecurityContextFactory securityContextFactory) {
        this.securityContextFactory = securityContextFactory;
    }

    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    public void reload() {
        log.info("container reload");
    }

    public void reload(ResourceConfig configuration) {
        log.info("container reload with new configuration {}", (Object)configuration);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        URI requestUri;
        HttpRequest httpRequest = (HttpRequest)e.getMessage();
        try {
            requestUri = this.baseUri.resolve(httpRequest.getUri());
        }
        catch (IllegalArgumentException throwable) {
            log.debug("Client sent invalid URL. Closing connection.");
            DefaultExceptionEvent exceptionEvent = new DefaultExceptionEvent(ctx.getChannel(), (Throwable)throwable);
            this.invalidRequestSent(ctx, (ExceptionEvent)exceptionEvent);
            return;
        }
        if (this.securityContextFactory == null) {
            this.securityContextFactory = new DefaultSecurityContextFactory();
        }
        String[] schemeCreds = this.extractBasicAuthCredentials(HttpHeaders.getHeader((HttpMessage)httpRequest, (String)"Authorization"));
        String scheme = null;
        String user = null;
        String password = null;
        if (schemeCreds != null) {
            scheme = schemeCreds[0];
            user = schemeCreds[1];
            password = schemeCreds[2];
        }
        boolean isSecure = requestUri.getScheme().equalsIgnoreCase("https");
        SecurityContext securityContext = this.securityContextFactory.create(user, password, isSecure, scheme, ctx.getChannel().getRemoteAddress().toString());
        ContainerRequest containerRequest = new ContainerRequest(this.baseUri, requestUri, httpRequest.getMethod().getName(), securityContext, (PropertiesDelegate)new MapPropertiesDelegate());
        SocketAddress remoteAddress = ctx.getChannel().getRemoteAddress();
        containerRequest.setProperty(REQUEST_PROPERTY_REMOTE_ADDR, (Object)remoteAddress);
        HttpVersion protocolVersion = httpRequest.getProtocolVersion();
        ctx.setAttachment((Object)httpRequest);
        containerRequest.setEntityStream((InputStream)new ChannelBufferInputStream(httpRequest.getContent()));
        MultivaluedMap incomingHeaders = containerRequest.getHeaders();
        if (securityContext instanceof HeaderAwareSecurityContext) {
            ((HeaderAwareSecurityContext)securityContext).setHeaders((MultivaluedMap<String, String>)containerRequest.getHeaders());
        }
        for (Map.Entry headerEntry : httpRequest.headers()) {
            incomingHeaders.add(headerEntry.getKey(), headerEntry.getValue());
        }
        boolean closeConnection = protocolVersion == HttpVersion.HTTP_1_0;
        String connectionHeader = HttpHeaders.getHeader((HttpMessage)httpRequest, (String)"Connection");
        if (connectionHeader != null && connectionHeader.equals("close")) {
            closeConnection = true;
        }
        containerRequest.setWriter((ContainerResponseWriter)new NettyResponseWriter(protocolVersion, closeConnection, e.getChannel()));
        Date responseDate = new Date();
        containerRequest.getHeaders().add((Object)"Date", (Object)HttpDateFormat.getPreferedDateFormat().format(responseDate));
        this.appHandler.handle(containerRequest);
        MultivaluedMap headers = containerRequest.getHeaders();
        for (Map.Entry header : httpRequest.headers()) {
            headers.add(header.getKey(), header.getValue());
        }
    }

    private String[] extractBasicAuthCredentials(String authorizationHeader) {
        if (authorizationHeader == null) {
            return null;
        }
        String[] schemeUserPass = new String[3];
        String[] headerParts = authorizationHeader.split(" ");
        if (headerParts != null && headerParts.length == 2) {
            schemeUserPass[0] = headerParts[0].equalsIgnoreCase("basic") ? "BASIC" : null;
            String credentials = Base64.decodeAsString((String)headerParts[1]);
            String[] userPass = credentials.split(":");
            if (userPass != null && userPass.length == 2) {
                schemeUserPass[1] = userPass[0].replaceAll("%40", "@");
                schemeUserPass[2] = userPass[1];
            }
            return schemeUserPass;
        }
        return null;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        log.error("Uncaught exception during jersey resource handling", e.getCause());
        Channel channel = ctx.getChannel();
        if (!channel.isOpen()) {
            log.info("Not writing any response, channel is already closed.", e.getCause());
            return;
        }
        HttpRequest request = (HttpRequest)ctx.getAttachment();
        HttpVersion protocolVersion = request != null && request.getProtocolVersion() != null ? request.getProtocolVersion() : HttpVersion.HTTP_1_0;
        DefaultHttpResponse response = new DefaultHttpResponse(protocolVersion, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        new ChannelBufferOutputStream(buffer).writeBytes(e.toString());
        response.setContent(buffer);
        ChannelFuture channelFuture = channel.write((Object)response);
        if (protocolVersion == HttpVersion.HTTP_1_0 || request == null || HttpHeaders.getHeader((HttpMessage)request, (String)"Connection").equalsIgnoreCase("close")) {
            channelFuture.addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void invalidRequestSent(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        Channel channel = ctx.getChannel();
        if (channel == null || !channel.isOpen()) {
            log.info("Not writing any response, channel is already closed.", e.getCause());
            return;
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_0, HttpResponseStatus.BAD_REQUEST);
        response.headers().add("Content-Type", (Object)"text/plain");
        response.headers().add("Connection", (Object)"close");
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        new ChannelBufferOutputStream(buffer).writeBytes("Your client has sent a malformed or illegal request.\n");
        response.setContent(buffer);
        ChannelFuture channelFuture = channel.write((Object)response);
        channelFuture.addListener(ChannelFutureListener.CLOSE);
    }

    private static final class NettyResponseWriter
    implements ContainerResponseWriter {
        private final HttpVersion protocolVersion;
        private final boolean connectionClose;
        private final Channel channel;
        private DefaultHttpResponse httpResponse;

        public NettyResponseWriter(HttpVersion protocolVersion, boolean connectionClose, Channel channel) {
            this.protocolVersion = protocolVersion;
            this.connectionClose = connectionClose;
            this.channel = channel;
        }

        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse responseContext) throws ContainerException {
            this.httpResponse = new DefaultHttpResponse(this.protocolVersion, HttpResponseStatus.valueOf((int)responseContext.getStatus()));
            long length = contentLength;
            if (length == -1L && responseContext.getEntity() instanceof String) {
                String entity = (String)responseContext.getEntity();
                byte[] encodedBytes = entity.getBytes(Charset.forName("UTF-8"));
                length = encodedBytes.length;
            }
            if (!responseContext.getHeaders().containsKey((Object)"Content-Length")) {
                HttpHeaders.setContentLength((HttpMessage)this.httpResponse, (long)length);
                log.trace("Writing response status and headers {}, length {}", (Object)responseContext, (Object)length);
            }
            for (Map.Entry headerEntry : responseContext.getHeaders().entrySet()) {
                HttpHeaders.addHeader((HttpMessage)this.httpResponse, (String)((String)headerEntry.getKey()), (Object)NettyResponseWriter.join((List)headerEntry.getValue(), ", "));
            }
            if (this.protocolVersion.equals((Object)HttpVersion.HTTP_1_1) && HttpHeaders.getContentLength((HttpMessage)this.httpResponse, (long)-3L) != -3L) {
                this.httpResponse.setChunked(true);
                HttpHeaders.setTransferEncodingChunked((HttpMessage)this.httpResponse);
                this.channel.write((Object)this.httpResponse);
                return new OutputStream(){

                    @Override
                    public void write(byte[] b, int off, int len) {
                        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((byte[])b, (int)off, (int)len);
                        if (log.isTraceEnabled()) {
                            log.trace("writing data: {}", (Object)buffer.toString(Charset.defaultCharset()));
                        }
                        NettyResponseWriter.this.channel.write((Object)new DefaultHttpChunk(buffer));
                        if (log.isDebugEnabled()) {
                            log.debug("wrote {} bytes as chunk", (Object)len);
                        }
                    }

                    @Override
                    public void write(int b) {
                        ChannelBuffer content = ChannelBuffers.copiedBuffer((byte[])new byte[]{(byte)b});
                        if (log.isTraceEnabled()) {
                            log.trace("writing data: {}", (Object)content.toString(Charset.defaultCharset()));
                        }
                        NettyResponseWriter.this.channel.write((Object)new DefaultHttpChunk(content));
                    }
                };
            }
            this.httpResponse.setContent(ChannelBuffers.dynamicBuffer());
            return new ChannelBufferOutputStream(this.httpResponse.getContent());
        }

        private static String join(List<Object> list, String delimiter) {
            StringBuilder sb = new StringBuilder();
            String currentDelimiter = "";
            for (Object o : list) {
                sb.append(currentDelimiter);
                sb.append(o.toString());
                currentDelimiter = delimiter;
            }
            return sb.toString();
        }

        public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            log.debug("Trying to suspend for {} ms, handler {}", (Object)timeUnit.toMillis(timeOut), (Object)timeoutHandler);
            return false;
        }

        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            log.debug("Setting suspend timeout to {} ms", (Object)timeUnit.toMillis(timeOut));
        }

        public void commit() {
            if (this.channel.isOpen()) {
                ChannelFuture channelFuture;
                if (this.httpResponse.isChunked()) {
                    if (log.isTraceEnabled()) {
                        log.trace("Writing last chunk to {}", (Object)this.channel.getRemoteAddress());
                    }
                    channelFuture = this.channel.write((Object)new DefaultHttpChunkTrailer());
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace("Writing entire {} bytes to client {}", (Object)this.httpResponse.getContent().readableBytes(), (Object)this.channel.getRemoteAddress());
                    }
                    channelFuture = this.channel.write((Object)this.httpResponse);
                }
                if (this.connectionClose) {
                    log.debug("Closing connection to {}", (Object)this.channel.getRemoteAddress());
                    channelFuture.addListener(ChannelFutureListener.CLOSE);
                } else {
                    channelFuture.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
                }
            }
        }

        public void failure(Throwable error) {
            log.error("Uncaught exception in transport layer. This is likely a bug, closing channel.", error);
            if (this.channel.isOpen()) {
                if (this.channel.isWritable()) {
                    DefaultHttpResponse internalServerResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_0, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    try {
                        internalServerResponse.setContent(ChannelBuffers.wrappedBuffer((byte[])("Uncaught exception!\n" + error.getMessage()).getBytes("UTF-8")));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    this.channel.write((Object)internalServerResponse).addListener(ChannelFutureListener.CLOSE);
                } else {
                    this.channel.close();
                }
            }
        }

        public boolean enableResponseBuffering() {
            return false;
        }
    }
}

