/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.log4j2;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.net.Severity;
import org.apache.logging.log4j.status.StatusLogger;
import org.graylog2.gelfclient.GelfConfiguration;
import org.graylog2.gelfclient.GelfMessage;
import org.graylog2.gelfclient.GelfMessageBuilder;
import org.graylog2.gelfclient.GelfMessageLevel;
import org.graylog2.gelfclient.GelfTransports;
import org.graylog2.gelfclient.transport.GelfTransport;

@Plugin(name="GELF", category="Core", elementType="appender", printObject=true)
public class GelfAppender
extends AbstractAppender {
    private static final long serialVersionUID = 4796033328540158817L;
    private static final Logger LOG = StatusLogger.getLogger();
    private final GelfConfiguration gelfConfiguration;
    private final String hostName;
    private final boolean includeSource;
    private final boolean includeThreadContext;
    private final boolean includeStackTrace;
    private final boolean includeExceptionCause;
    private final Map<String, Object> additionalFields;
    private GelfTransport client;

    protected GelfAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, GelfConfiguration gelfConfiguration, String hostName, boolean includeSource, boolean includeThreadContext, boolean includeStackTrace, String additionalFields, boolean includeExceptionCause) {
        super(name, filter, layout, ignoreExceptions);
        this.gelfConfiguration = gelfConfiguration;
        this.hostName = hostName;
        this.includeSource = includeSource;
        this.includeThreadContext = includeThreadContext;
        this.includeStackTrace = includeStackTrace;
        this.includeExceptionCause = includeExceptionCause;
        if (null != additionalFields && !additionalFields.isEmpty()) {
            this.additionalFields = new HashMap<String, Object>();
            try {
                String[] values;
                for (String s : values = additionalFields.split(",")) {
                    String[] nvp = s.split("=");
                    this.additionalFields.put(nvp[0], nvp[1]);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to read additional fields.", (Throwable)e);
            }
        } else {
            this.additionalFields = Collections.emptyMap();
        }
    }

    public void append(LogEvent event) {
        GelfMessageBuilder builder = new GelfMessageBuilder(event.getMessage().getFormattedMessage(), this.hostName).timestamp((double)event.getTimeMillis() / 1000.0).level(GelfMessageLevel.fromNumericLevel((int)Severity.getSeverity((Level)event.getLevel()).getCode())).additionalField("loggerName", (Object)event.getLoggerName()).additionalField("threadName", (Object)event.getThreadName());
        Marker marker = event.getMarker();
        if (marker != null) {
            builder.additionalField("marker", (Object)marker.getName());
        }
        if (this.includeThreadContext) {
            for (Map.Entry entry : event.getContextMap().entrySet()) {
                builder.additionalField((String)entry.getKey(), entry.getValue());
            }
            List contextStack = event.getContextStack().asList();
            if (contextStack != null && !contextStack.isEmpty()) {
                builder.additionalField("contextStack", (Object)contextStack.toString());
            }
        }
        StackTraceElement source = event.getSource();
        if (this.includeSource && source != null) {
            builder.additionalField("sourceFileName", (Object)source.getFileName());
            builder.additionalField("sourceMethodName", (Object)source.getMethodName());
            builder.additionalField("sourceClassName", (Object)source.getClassName());
            builder.additionalField("sourceLineNumber", (Object)source.getLineNumber());
        }
        Throwable thrown = event.getThrown();
        if (this.includeStackTrace && thrown != null) {
            String stackTrace;
            if (this.includeExceptionCause) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                thrown.printStackTrace(printWriter);
                stackTrace = stringWriter.toString();
            } else {
                stackTrace = this.getSimpleStacktraceAsString(thrown);
            }
            builder.additionalField("exceptionClass", (Object)thrown.getClass().getCanonicalName());
            builder.additionalField("exceptionMessage", (Object)thrown.getMessage());
            builder.additionalField("exceptionStackTrace", (Object)stackTrace);
            builder.fullMessage(event.getMessage().getFormattedMessage());
        }
        if (!this.additionalFields.isEmpty()) {
            builder.additionalFields(this.additionalFields);
        }
        GelfMessage gelfMessage = builder.build();
        try {
            boolean sent = this.client.trySend(gelfMessage);
            if (!sent) {
                LOG.debug("Couldn't send message: {}", new Object[]{gelfMessage});
            }
        }
        catch (Exception e) {
            throw new AppenderLoggingException("failed to write log event to GELF server: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String getSimpleStacktraceAsString(Throwable thrown) {
        StringBuilder stackTraceBuilder = new StringBuilder();
        for (StackTraceElement stackTraceElement : thrown.getStackTrace()) {
            new Formatter(stackTraceBuilder).format("%s.%s(%s:%d)%n", stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber());
        }
        return stackTraceBuilder.toString();
    }

    protected void setClient(GelfTransport client) {
        this.client = Objects.requireNonNull(client);
    }

    public void start() {
        super.start();
        this.client = GelfTransports.create((GelfConfiguration)this.gelfConfiguration);
    }

    public void stop() {
        super.stop();
        if (this.client != null) {
            this.client.stop();
        }
    }

    public String toString() {
        return GelfAppender.class.getSimpleName() + "{name=" + this.getName() + ",server=" + this.gelfConfiguration.getRemoteAddress().getHostName() + ",port=" + this.gelfConfiguration.getRemoteAddress().getPort() + ",protocol=" + this.gelfConfiguration.getTransport().toString() + ",hostName=" + this.hostName + ",queueSize=" + this.gelfConfiguration.getQueueSize() + ",connectTimeout=" + this.gelfConfiguration.getConnectTimeout() + ",reconnectDelay=" + this.gelfConfiguration.getReconnectDelay() + ",sendBufferSize=" + this.gelfConfiguration.getSendBufferSize() + ",tcpNoDelay=" + this.gelfConfiguration.isTcpNoDelay() + ",tcpKeepAlive=" + this.gelfConfiguration.isTcpKeepAlive() + ",tlsEnabled=" + this.gelfConfiguration.isTlsEnabled() + ",tlsCertVerificationEnabled=" + this.gelfConfiguration.isTlsCertVerificationEnabled() + ",tlsTrustCertChainFilename=" + (this.gelfConfiguration.getTlsTrustCertChainFile() != null ? this.gelfConfiguration.getTlsTrustCertChainFile().getPath() : "null") + "}";
    }

    @PluginFactory
    public static GelfAppender createGelfAppender(@PluginElement(value="Filter") Filter filter, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginAttribute(value="name") String name, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) Boolean ignoreExceptions, @PluginAttribute(value="server", defaultString="localhost") String server, @PluginAttribute(value="port", defaultInt=12201) Integer port, @PluginAttribute(value="protocol", defaultString="UDP") String protocol, @PluginAttribute(value="hostName") String hostName, @PluginAttribute(value="queueSize", defaultInt=512) Integer queueSize, @PluginAttribute(value="connectTimeout", defaultInt=1000) Integer connectTimeout, @PluginAttribute(value="reconnectDelay", defaultInt=500) Integer reconnectDelay, @PluginAttribute(value="sendBufferSize", defaultInt=-1) Integer sendBufferSize, @PluginAttribute(value="tcpNoDelay", defaultBoolean=false) Boolean tcpNoDelay, @PluginAttribute(value="tcpKeepAlive", defaultBoolean=false) Boolean tcpKeepAlive, @PluginAttribute(value="includeSource", defaultBoolean=true) Boolean includeSource, @PluginAttribute(value="includeThreadContext", defaultBoolean=true) Boolean includeThreadContext, @PluginAttribute(value="includeStackTrace", defaultBoolean=true) Boolean includeStackTrace, @PluginAttribute(value="includeExceptionCause", defaultBoolean=false) Boolean includeExceptionCause, @PluginAttribute(value="additionalFields") String additionalFields, @PluginAttribute(value="tlsEnabled", defaultBoolean=false) Boolean tlsEnabled, @PluginAttribute(value="tlsEnableCertificateVerification", defaultBoolean=true) Boolean tlsEnableCertificateVerification, @PluginAttribute(value="tlsTrustCertChainFilename") String tlsTrustCertChainFilename) {
        if (name == null) {
            LOGGER.error("No name provided for ConsoleAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        if (!"UDP".equalsIgnoreCase(protocol) && !"TCP".equalsIgnoreCase(protocol)) {
            LOG.warn("Invalid protocol {}, falling back to UDP", new Object[]{protocol});
            protocol = "UDP";
        }
        if (hostName == null || hostName.trim().isEmpty()) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LOG.warn("Couldn't detect local host name, falling back to \"localhost\"");
                hostName = "localhost";
            }
        }
        InetSocketAddress serverAddress = new InetSocketAddress(server, (int)port);
        GelfTransports gelfProtocol = GelfTransports.valueOf((String)protocol.toUpperCase());
        GelfConfiguration gelfConfiguration = new GelfConfiguration(serverAddress).transport(gelfProtocol).queueSize(queueSize.intValue()).connectTimeout(connectTimeout.intValue()).reconnectDelay(reconnectDelay.intValue()).sendBufferSize(sendBufferSize.intValue()).tcpNoDelay(tcpNoDelay.booleanValue()).tcpKeepAlive(tcpKeepAlive.booleanValue());
        if (tlsEnabled.booleanValue()) {
            if (gelfProtocol.equals((Object)GelfTransports.TCP)) {
                gelfConfiguration.enableTls();
                if (!tlsEnableCertificateVerification.booleanValue()) {
                    LOG.warn("TLS certificate validation is disabled. This is unsecure!");
                    gelfConfiguration.disableTlsCertVerification();
                }
                if (tlsEnableCertificateVerification.booleanValue() && tlsTrustCertChainFilename != null) {
                    gelfConfiguration.tlsTrustCertChainFile(new File(tlsTrustCertChainFilename));
                }
            } else {
                LOG.warn("Enabling of TLS is invalid for UDP Transport");
            }
        }
        return new GelfAppender(name, (Layout<? extends Serializable>)layout, filter, ignoreExceptions, gelfConfiguration, hostName, includeSource, includeThreadContext, includeStackTrace, additionalFields, includeExceptionCause);
    }
}

