/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.graylog2.logback.appender.GelfTcpAppender;
import org.graylog2.logback.appender.Graylog2Plugin;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.Delimiters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.core.enhancers.PropertiesEnhancer;
import play.libs.Json;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class GelfAppenderHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger log = LoggerFactory.getLogger(GelfAppenderHandler.class);
    private final Graylog2Plugin graylog2Plugin;
    private BlockingQueue<String> queue;
    private Channel channel;
    private AtomicBoolean keepRunning = new AtomicBoolean(true);
    private final Thread senderThread;
    private ReentrantLock lock;
    private Condition connectedCond;

    public GelfAppenderHandler(Graylog2Plugin graylog2Plugin, int capacity) {
        this.graylog2Plugin = graylog2Plugin;
        this.queue = new LinkedBlockingQueue<String>(capacity);
        this.lock = new ReentrantLock();
        this.connectedCond = this.lock.newCondition();
        this.senderThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String gelf = null;
                while (GelfAppenderHandler.this.keepRunning.get()) {
                    GelfAppenderHandler.this.lock.lock();
                    try {
                        while (GelfAppenderHandler.this.channel == null || !GelfAppenderHandler.this.channel.isConnected()) {
                            try {
                                GelfAppenderHandler.this.connectedCond.await();
                            }
                            catch (InterruptedException e) {
                                if (GelfAppenderHandler.this.keepRunning.get()) continue;
                                break;
                            }
                        }
                        try {
                            if (gelf == null) {
                                gelf = (String)GelfAppenderHandler.this.queue.poll(100L, TimeUnit.MILLISECONDS);
                            }
                            if (gelf == null || GelfAppenderHandler.this.channel == null || !GelfAppenderHandler.this.channel.isConnected()) continue;
                            ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{ChannelBuffers.wrappedBuffer((byte[])gelf.getBytes(Charsets.UTF_8)), Delimiters.nulDelimiter()[0]});
                            GelfAppenderHandler.this.channel.write((Object)buffer);
                            gelf = null;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    finally {
                        GelfAppenderHandler.this.lock.unlock();
                    }
                }
            }
        });
        this.senderThread.start();
    }

    private String convertToGelf(ILoggingEvent event) {
        ObjectNode gelf = Json.newObject();
        gelf.put("short_message", event.getFormattedMessage());
        gelf.put("host", this.graylog2Plugin.getLocalHostName());
        gelf.put("timestamp", (double)event.getTimeStamp() / 1000.0);
        gelf.put("threadname", event.getThreadName());
        gelf.put("logger", event.getLoggerName());
        gelf.put("loglevel", event.getLevel().toString());
        return gelf.toString();
    }

    public boolean offer(ILoggingEvent event) {
        return this.offer(this.convertToGelf(event));
    }

    public boolean offer(String gelf) {
        if (log.isTraceEnabled()) {
            log.trace(GelfTcpAppender.DONT_SEND_TO_GRAYLOG2, "Remaining capacity in GELF queue: {} elements. offering: {}", (Object)this.queue.remainingCapacity(), (Object)gelf);
        }
        return this.queue.offer(gelf);
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.lock.lock();
        try {
            if (log.isDebugEnabled()) {
                log.debug(GelfTcpAppender.DONT_SEND_TO_GRAYLOG2, "Connection to graylog2 server at {} established.", (Object)ctx.getChannel().getRemoteAddress());
            }
            this.channel = e.getChannel();
            this.connectedCond.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        if (log.isDebugEnabled() && !(e.getCause() instanceof IOException)) {
            log.debug(GelfTcpAppender.DONT_SEND_TO_GRAYLOG2, "Caught exception during sending log event to graylog2 " + e);
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(GelfTcpAppender.DONT_SEND_TO_GRAYLOG2, "Connection lost to graylog2 server.");
        }
        this.lock.lock();
        try {
            this.channel = null;
            if (this.keepRunning.get()) {
                this.graylog2Plugin.reconnect();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stop() {
        this.keepRunning.set(false);
        this.senderThread.interrupt();
    }
}

