/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.logback.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import org.graylog2.logback.appender.GelfAppenderHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.BasicMarkerFactory;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class GelfTcpAppender
extends AppenderBase<ILoggingEvent> {
    private static final Logger log = LoggerFactory.getLogger(GelfAppenderHandler.class);
    private final GelfAppenderHandler handler;
    public static final Marker DONT_SEND_TO_GRAYLOG2 = new BasicMarkerFactory().getMarker("GRAYLOG2_IGNORE_MARKER");

    public GelfTcpAppender(GelfAppenderHandler handler) {
        this.handler = handler;
        this.setName("Graylog2-TCP");
    }

    protected void append(ILoggingEvent event) {
        if (event == null || !this.isStarted()) {
            return;
        }
        if (event.getMarker() != null && event.getMarker().contains(DONT_SEND_TO_GRAYLOG2)) {
            return;
        }
        boolean added = this.handler.offer(event);
        if (!added) {
            log.warn(DONT_SEND_TO_GRAYLOG2, "Graylog2 appender queue ran out of capacity, dropping log message {}", (Object)event);
        }
    }
}

