/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.logback.appender;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import com.google.common.base.Splitter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.graylog2.logback.appender.GelfAppenderHandler;
import org.graylog2.logback.appender.GelfTcpAppender;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.oio.OioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.Application;
import play.Configuration;
import play.Plugin;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class Graylog2Plugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(Graylog2Plugin.class);
    private final Long connectTimeout;
    private final Boolean isTcpNoDelay;
    private final Integer sendBufferSize;
    private final Boolean accessLogEnabled;
    private String canonicalHostName;
    private ChannelFuture channelFuture;
    private GelfTcpAppender gelfAppender;
    private GelfAppenderHandler handler;
    private InetSocketAddress graylog2ServerAddress;
    private final Integer queueCapacity;
    private ClientBootstrap bootstrap;
    private ReconnectListener reconnectListener;
    private ExecutorService reconnectExecutor;
    private ReconnectRunnable reconnector;
    private final Long reconnectInterval;

    public Graylog2Plugin(Application app) {
        Configuration config = app.configuration();
        this.accessLogEnabled = config.getBoolean("graylog2.appender.send-access-log", Boolean.valueOf(false));
        this.queueCapacity = config.getInt("graylog2.appender.queue-size", Integer.valueOf(512));
        this.reconnectInterval = config.getMilliseconds("graylog2.appender.reconnect-interval", Long.valueOf(500L));
        this.connectTimeout = config.getMilliseconds("graylog2.appender.connect-timeout", Long.valueOf(1000L));
        this.isTcpNoDelay = config.getBoolean("graylog2.appender.tcp-nodelay", Boolean.valueOf(false));
        this.sendBufferSize = config.getInt("graylog2.appender.sendbuffersize", Integer.valueOf(0));
        try {
            this.canonicalHostName = config.getString("graylog2.appender.sourcehost", InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (UnknownHostException e) {
            this.canonicalHostName = "localhost";
            log.error("Unable to resolve canonical localhost name. Please set it manually via graylog2.appender.sourcehost or fix your lookup service, falling back to {}", (Object)this.canonicalHostName);
        }
        String entry = config.getString("graylog2.appender.host", "127.0.0.1:12201");
        Iterable parts = Splitter.on((char)':').trimResults().omitEmptyStrings().limit(2).split((CharSequence)entry.toString());
        Iterator it = parts.iterator();
        try {
            String host = (String)it.next();
            String port = (String)it.next();
            this.graylog2ServerAddress = new InetSocketAddress(host, (int)Integer.valueOf(port));
        }
        catch (IllegalArgumentException | NoSuchElementException e) {
            log.error("Malformed graylog2.appender.hosts entry {}. Please specify them as 'host:port'!", (Object)entry);
        }
        this.reconnectExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("graylog2-appender-reconnect-%d").build());
        this.reconnector = new ReconnectRunnable();
    }

    public void onStart() {
        this.bootstrap = new ClientBootstrap((ChannelFactory)new OioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool()));
        this.reconnectListener = new ReconnectListener();
        this.handler = new GelfAppenderHandler(this, this.queueCapacity);
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{Graylog2Plugin.this.handler});
            }
        });
        this.bootstrap.setOption("connectTimeoutMillis", (Object)this.connectTimeout);
        this.bootstrap.setOption("tcpNoDelay", (Object)this.isTcpNoDelay);
        if (this.sendBufferSize > 0) {
            this.bootstrap.setOption("sendBufferSize", (Object)this.sendBufferSize);
        }
        this.reconnectExecutor.execute(this.reconnector);
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger rootLogger = lc.getLogger("ROOT");
        this.gelfAppender = new GelfTcpAppender(this.handler);
        this.gelfAppender.setContext((Context)lc);
        this.gelfAppender.start();
        rootLogger.addAppender((Appender)this.gelfAppender);
    }

    public ChannelFuture reconnect() {
        if (log.isDebugEnabled()) {
            log.debug(GelfTcpAppender.DONT_SEND_TO_GRAYLOG2, "Reconnecting to graylog2 at {}", (Object)this.graylog2ServerAddress);
        }
        this.channelFuture = this.bootstrap.connect((SocketAddress)this.graylog2ServerAddress);
        this.channelFuture.addListener((ChannelFutureListener)this.reconnectListener);
        return this.channelFuture;
    }

    public void onStop() {
        if (this.gelfAppender != null) {
            this.gelfAppender.stop();
        }
        if (this.handler != null) {
            this.handler.stop();
        }
        if (this.channelFuture.getChannel() != null) {
            this.channelFuture.getChannel().close().awaitUninterruptibly();
        }
    }

    public GelfAppenderHandler getGelfHandler() {
        return this.handler;
    }

    public String getLocalHostName() {
        return this.canonicalHostName;
    }

    public boolean isAccessLogEnabled() {
        return this.accessLogEnabled;
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private class ReconnectListener
    implements ChannelFutureListener {
        private ReconnectListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                if (log.isDebugEnabled()) {
                    log.debug(GelfTcpAppender.DONT_SEND_TO_GRAYLOG2, "Could not connect. Retrying in {} ms. Exception {}", (Object)Graylog2Plugin.this.reconnectInterval, (Object)future.getCause().getMessage());
                }
                Graylog2Plugin.this.reconnectExecutor.execute(Graylog2Plugin.this.reconnector);
            }
        }
    }

    @PropertiesEnhancer.GeneratedAccessor
    @PropertiesEnhancer.RewrittenAccessor
    private class ReconnectRunnable
    implements Runnable {
        private ReconnectRunnable() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(Graylog2Plugin.this.reconnectInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Graylog2Plugin.this.channelFuture = Graylog2Plugin.this.reconnect();
        }
    }
}

