/*
 * Decompiled with CFR 0.152.
 */
package oi.thekraken.grok.api;

import com.google.code.regexp.Matcher;
import com.google.code.regexp.Pattern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import oi.thekraken.grok.api.Grok;
import oi.thekraken.grok.api.Match;
import oi.thekraken.grok.api.exception.GrokException;
import org.apache.commons.lang3.StringUtils;

public class Discovery {
    private Grok grok;

    public Discovery(Grok grok) {
        this.grok = grok;
    }

    private Map<String, Grok> sort(Map<String, Grok> groks) {
        ArrayList<Grok> groky = new ArrayList<Grok>(groks.values());
        LinkedHashMap<String, Grok> mGrok = new LinkedHashMap<String, Grok>();
        Collections.sort(groky, new Comparator<Grok>(){

            @Override
            public int compare(Grok g1, Grok g2) {
                return this.complexity(g1.getNamedRegex()) < this.complexity(g2.getNamedRegex()) ? 1 : 0;
            }

            private int complexity(String expandedPattern) {
                int score = 0;
                score += expandedPattern.split("\\Q|\\E", -1).length - 1;
                return score += expandedPattern.length();
            }
        });
        for (Grok g : groky) {
            mGrok.put(g.getSaved_pattern(), g);
        }
        return mGrok;
    }

    private int complexity(String expandedPattern) {
        int score = 0;
        score += expandedPattern.split("\\Q|\\E", -1).length - 1;
        return score += expandedPattern.length();
    }

    public String discover(String text) {
        if (text == null) {
            return "";
        }
        TreeMap<String, Grok> groks = new TreeMap<String, Grok>();
        Map<String, String> gPatterns = this.grok.getPatterns();
        String texte = text;
        for (Map.Entry<String, String> pairs : gPatterns.entrySet()) {
            String key = pairs.getKey().toString();
            Grok g = new Grok();
            try {
                g.copyPatterns(gPatterns);
                g.setSaved_pattern(key);
                g.compile("%{" + key + "}");
                groks.put(key, g);
            }
            catch (GrokException e) {}
        }
        Map<String, Grok> patterns = this.sort(groks);
        for (Map.Entry<String, Grok> pairs : patterns.entrySet()) {
            Pattern pattern2;
            Matcher ma2;
            Match m;
            String key = pairs.getKey().toString();
            Grok value = pairs.getValue();
            if (this.complexity(value.getNamedRegex()) < 20 || (m = value.match(text)).isNull().booleanValue()) continue;
            String part = this.getPart(m, text);
            Pattern pattern = Pattern.compile((String)".\\b.");
            Matcher ma = pattern.matcher((CharSequence)part);
            if (!ma.find() || (ma2 = (pattern2 = Pattern.compile((String)"%\\{[^}+]\\}")).matcher((CharSequence)part)).find()) continue;
            texte = StringUtils.replace((String)texte, (String)part, (String)("%{" + key + "}"));
        }
        return texte;
    }

    private String getPart(Match m, String text) {
        if (m == null || text == null) {
            return "";
        }
        return text.substring(m.getStart(), m.getEnd());
    }
}

