/*
 * Decompiled with CFR 0.152.
 */
package io.thekraken.grok.api;

import io.thekraken.grok.api.DateConverter;
import io.thekraken.grok.api.IConverter;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Converter {
    private static final Pattern SPLITTER = Pattern.compile("[:;]");
    private static final Map<String, Type> TYPES = Arrays.stream(Type.values()).collect(Collectors.toMap(t -> t.name().toLowerCase(), t -> t));
    private static final Map<String, Type> TYPE_ALIASES = Arrays.stream(Type.values()).flatMap(type -> type.aliases.stream().map(alias -> new AbstractMap.SimpleEntry<String, Type>((String)alias, (Type)((Object)type)))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    private static Type getType(String key) {
        Type type = TYPES.getOrDefault(key = key.toLowerCase(), TYPE_ALIASES.get(key));
        if (type == null) {
            throw new IllegalArgumentException("Invalid data type :" + key);
        }
        return type;
    }

    public static Map<String, IConverter> getConverters(Collection<String> groupNames, Object ... params) {
        return groupNames.stream().filter(Converter::containsDelimiter).collect(Collectors.toMap(Function.identity(), key -> {
            String[] list = Converter.splitGrokPattern(key);
            IConverter<?> converter = Converter.getType((String)list[1]).converter;
            if (list.length == 3) {
                converter = converter.newConverter(list[2], params);
            }
            return converter;
        }));
    }

    public static Map<String, Type> getGroupTypes(Collection<String> groupNames) {
        return groupNames.stream().filter(Converter::containsDelimiter).map(Converter::splitGrokPattern).collect(Collectors.toMap(l -> l[0], l -> Converter.getType(l[1])));
    }

    public static String extractKey(String key) {
        return Converter.splitGrokPattern(key)[0];
    }

    private static boolean containsDelimiter(String s) {
        return s.indexOf(58) >= 0 || s.indexOf(59) >= 0;
    }

    private static String[] splitGrokPattern(String s) {
        return SPLITTER.split(s, 3);
    }

    public static enum Type {
        BYTE(Byte::valueOf, new String[0]),
        BOOLEAN(Boolean::valueOf, new String[0]),
        SHORT(Short::valueOf, new String[0]),
        INT(Integer::valueOf, "integer"),
        LONG(Long::valueOf, new String[0]),
        FLOAT(Float::valueOf, new String[0]),
        DOUBLE(Double::valueOf, new String[0]),
        DATETIME(new DateConverter(), "date"),
        STRING(v -> v, "text");

        public final IConverter<?> converter;
        public final List<String> aliases;

        private Type(IConverter<?> converter, String ... aliases) {
            this.converter = converter;
            this.aliases = Arrays.asList(aliases);
        }
    }
}

