/*
 * Decompiled with CFR 0.152.
 */
package io.thekraken.grok.api;

import io.thekraken.grok.api.IConverter;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

class DateConverter
implements IConverter<Instant> {
    private final DateTimeFormatter formatter;
    private final ZoneId timeZone;

    public DateConverter() {
        this.formatter = DateTimeFormatter.ISO_DATE_TIME;
        this.timeZone = ZoneOffset.UTC;
    }

    private DateConverter(DateTimeFormatter formatter, ZoneId timeZone) {
        this.formatter = formatter;
        this.timeZone = timeZone;
    }

    @Override
    public Instant convert(String value) {
        TemporalAccessor dt = this.formatter.parseBest(value.trim(), ZonedDateTime::from, LocalDateTime::from, OffsetDateTime::from, Instant::from, LocalDate::from);
        if (dt instanceof ZonedDateTime) {
            return ((ZonedDateTime)dt).toInstant();
        }
        if (dt instanceof LocalDateTime) {
            return ((LocalDateTime)dt).atZone(this.timeZone).toInstant();
        }
        if (dt instanceof OffsetDateTime) {
            return ((OffsetDateTime)dt).atZoneSameInstant(this.timeZone).toInstant();
        }
        if (dt instanceof Instant) {
            return (Instant)dt;
        }
        if (dt instanceof LocalDate) {
            return ((LocalDate)dt).atStartOfDay(this.timeZone).toInstant();
        }
        return null;
    }

    public DateConverter newConverter(String param, Object ... params) {
        if (params.length != 1 || !(params[0] instanceof ZoneId)) {
            throw new IllegalArgumentException("Invalid parameters");
        }
        return new DateConverter(DateTimeFormatter.ofPattern(param), (ZoneId)params[0]);
    }
}

