/*
 * Decompiled with CFR 0.152.
 */
package io.thekraken.grok.api;

import io.thekraken.grok.api.Grok;
import io.thekraken.grok.api.GrokCompiler;
import io.thekraken.grok.api.Match;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Discovery {
    private Grok grok;

    public Discovery(Grok grok) {
        this.grok = grok;
    }

    private Map<String, Grok> sort(Map<String, Grok> groks) {
        ArrayList<Grok> groky = new ArrayList<Grok>(groks.values());
        LinkedHashMap<String, Grok> mGrok = new LinkedHashMap<String, Grok>();
        groky.sort(new Comparator<Grok>(){

            @Override
            public int compare(Grok g1, Grok g2) {
                return this.complexity(g1.getNamedRegex()) < this.complexity(g2.getNamedRegex()) ? 1 : 0;
            }

            private int complexity(String expandedPattern) {
                int score = 0;
                score += expandedPattern.split("\\Q|\\E", -1).length - 1;
                return score += expandedPattern.length();
            }
        });
        for (Grok g : groky) {
            mGrok.put(g.getSaved_pattern(), g);
        }
        return mGrok;
    }

    private int complexity(String expandedPattern) {
        int score = 0;
        score += expandedPattern.split("\\Q|\\E", -1).length - 1;
        return score += expandedPattern.length();
    }

    public String discover(String text) {
        String key;
        if (text == null) {
            return "";
        }
        TreeMap<String, Grok> groks = new TreeMap<String, Grok>();
        Map<String, String> gPatterns = this.grok.getPatterns();
        String texte = text;
        GrokCompiler compiler = GrokCompiler.newInstance();
        compiler.register(gPatterns);
        Iterator<Map.Entry<String, String>> iterator = gPatterns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> stringStringEntry;
            Map.Entry<String, String> entry = stringStringEntry = iterator.next();
            key = entry.getKey().toString();
            try {
                Grok g = compiler.compile("%{" + key + "}");
                g.setSaved_pattern(key);
                groks.put(key, g);
            }
            catch (Exception g) {}
        }
        Map<String, Grok> patterns = this.sort(groks);
        for (Map.Entry<String, Grok> entry : patterns.entrySet()) {
            Pattern pattern2;
            Matcher ma2;
            Match m;
            key = entry.getKey();
            Grok value = entry.getValue();
            if (this.complexity(value.getNamedRegex()) < 20 || (m = value.match(text)).isNull().booleanValue()) continue;
            String part = this.getPart(m, text);
            Pattern pattern = Pattern.compile(".\\b.");
            Matcher ma = pattern.matcher(part);
            if (!ma.find() || (ma2 = (pattern2 = Pattern.compile("%\\{[^}+]\\}")).matcher(part)).find()) continue;
            texte = StringUtils.replace((String)texte, (String)part, (String)("%{" + key + "}"));
        }
        return texte;
    }

    private String getPart(Match m, String text) {
        if (m == null || text == null) {
            return "";
        }
        return text.substring(m.getStart(), m.getEnd());
    }
}

