/*
 * Decompiled with CFR 0.152.
 */
package io.krakens.grok.api;

import com.google.code.regexp.Matcher;
import io.krakens.grok.api.Converter;
import io.krakens.grok.api.Grok;
import io.krakens.grok.api.exception.GrokException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Match {
    private final CharSequence subject;
    private final Grok grok;
    private final Matcher match;
    private final int start;
    private final int end;
    private boolean keepEmptyCaptures = true;
    private Map<String, Object> capture = Collections.emptyMap();
    public static final Match EMPTY = new Match("", null, null, 0, 0);

    public Match(CharSequence subject, Grok grok, Matcher match, int start, int end) {
        this.subject = subject;
        this.grok = grok;
        this.match = match;
        this.start = start;
        this.end = end;
    }

    public Matcher getMatch() {
        return this.match;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setKeepEmptyCaptures(boolean ignore) {
        if (this.capture.size() > 0) {
            this.capture = new LinkedHashMap<String, Object>();
        }
        this.keepEmptyCaptures = ignore;
    }

    public boolean isKeepEmptyCaptures() {
        return this.keepEmptyCaptures;
    }

    public CharSequence getSubject() {
        return this.subject;
    }

    public Map<String, Object> capture() {
        return this.capture(false);
    }

    public Map<String, Object> captureFlattened() {
        return this.capture(true);
    }

    private Map<String, Object> capture(boolean flattened) throws GrokException {
        if (this.match == null) {
            return Collections.emptyMap();
        }
        if (!this.capture.isEmpty()) {
            return this.capture;
        }
        this.capture = new LinkedHashMap<String, Object>();
        Map mappedw = this.match.namedGroups();
        mappedw.forEach((key, valueString) -> {
            String id = this.grok.getNamedRegexCollectionById((String)key);
            if (id != null && !id.isEmpty()) {
                key = id;
            }
            if ("UNWANTED".equals(key)) {
                return;
            }
            Object value = valueString;
            if (valueString != null) {
                Converter.IConverter<? extends Object> converter = this.grok.converters.get(key);
                if (converter != null) {
                    key = Converter.extractKey(key);
                    try {
                        value = converter.convert((String)valueString);
                    }
                    catch (Exception e) {
                        this.capture.put(key + "_grokfailure", e.toString());
                    }
                    if (value instanceof String) {
                        value = this.cleanString((String)value);
                    }
                } else {
                    value = this.cleanString((String)valueString);
                }
            } else {
                if (!this.isKeepEmptyCaptures()) {
                    return;
                }
                key = Converter.extractKey(key);
            }
            if (this.capture.containsKey(key)) {
                Object currentValue = this.capture.get(key);
                if (currentValue instanceof List) {
                    List cvl = (List)currentValue;
                    if (!cvl.contains(value)) {
                        cvl.add(value);
                    }
                } else if (value != null && !value.equals(currentValue)) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(currentValue);
                    list.add(value);
                    this.capture.put((String)key, list);
                }
            } else {
                this.capture.put((String)key, value);
            }
        });
        if (flattened) {
            this.capture.forEach((key, value) -> {
                if (value instanceof List) {
                    List valueList = ((List)value).stream().filter(Objects::nonNull).collect(Collectors.toList());
                    if (valueList.size() == 1) {
                        this.capture.put((String)key, valueList.iterator().next());
                    } else {
                        this.capture.put((String)key, valueList);
                    }
                }
            });
        }
        this.capture = Collections.unmodifiableMap(this.capture);
        return this.capture;
    }

    private String cleanString(String value) {
        char lastChar;
        if (value == null || value.isEmpty()) {
            return value;
        }
        char firstChar = value.charAt(0);
        if (firstChar == (lastChar = value.charAt(value.length() - 1)) && (firstChar == '\"' || firstChar == '\'')) {
            if (value.length() <= 2) {
                return "";
            }
            int found = 0;
            for (int i = 1; i < value.length() - 1; ++i) {
                if (value.charAt(i) != firstChar) continue;
                ++found;
            }
            if (found == 0) {
                return value.substring(1, value.length() - 1);
            }
        }
        return value;
    }

    public Boolean isNull() {
        return this.match == null;
    }
}

