/*
 * Decompiled with CFR 0.152.
 */
package com.joestelmach.natty.repackaged.net.fortuna.ical4j.model;

import com.joestelmach.natty.repackaged.net.fortuna.ical4j.util.Numbers;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class NumberList
extends ArrayList
implements Serializable {
    private static final long serialVersionUID = -1667481795613729889L;
    private final int minValue;
    private final int maxValue;
    private final boolean allowsNegativeValues;

    public NumberList() {
        this(Integer.MIN_VALUE, Integer.MAX_VALUE, true);
    }

    public NumberList(int minValue, int maxValue, boolean allowsNegativeValues) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.allowsNegativeValues = allowsNegativeValues;
    }

    public NumberList(String aString) {
        this(aString, Integer.MIN_VALUE, Integer.MAX_VALUE, true);
    }

    public NumberList(String aString, int minValue, int maxValue, boolean allowsNegativeValues) {
        this(minValue, maxValue, allowsNegativeValues);
        StringTokenizer t = new StringTokenizer(aString, ",");
        while (t.hasMoreTokens()) {
            int value = Numbers.parseInt(t.nextToken());
            this.add(new Integer(value));
        }
    }

    public final boolean add(Integer aNumber) {
        int abs = aNumber;
        if ((abs >> 31 | -abs >>> 31) < 0) {
            if (!this.allowsNegativeValues) {
                throw new IllegalArgumentException("Negative value not allowed: " + aNumber);
            }
            abs = Math.abs(abs);
        }
        if (abs < this.minValue || abs > this.maxValue) {
            throw new IllegalArgumentException("Value not in range [" + this.minValue + ".." + this.maxValue + "]: " + aNumber);
        }
        return this.add((Object)aNumber);
    }

    public final boolean add(Object arg0) {
        if (!(arg0 instanceof Integer)) {
            throw new IllegalArgumentException("Argument not a " + Integer.class.getName());
        }
        return super.add(arg0);
    }

    public final boolean remove(Integer aNumber) {
        return this.remove((Object)aNumber);
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            b.append(i.next());
            if (!i.hasNext()) continue;
            b.append(',');
        }
        return b.toString();
    }
}

