/*
 * Decompiled with CFR 0.152.
 */
package com.joestelmach.natty.repackaged.net.fortuna.ical4j.model;

import com.joestelmach.natty.repackaged.edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.Parameter;
import com.joestelmach.natty.repackaged.org.apache.commons.lang.ObjectUtils;
import com.joestelmach.natty.repackaged.org.apache.commons.lang.builder.HashCodeBuilder;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ParameterList
implements Serializable {
    private static final long serialVersionUID = -1913059830016450169L;
    private final List parameters;

    public ParameterList() {
        this(false);
    }

    public ParameterList(boolean unmodifiable) {
        this.parameters = unmodifiable ? Collections.unmodifiableList(new ArrayList()) : new CopyOnWriteArrayList();
    }

    public ParameterList(ParameterList list, boolean unmodifiable) throws URISyntaxException {
        CopyOnWriteArrayList parameterList = new CopyOnWriteArrayList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Parameter parameter = (Parameter)i.next();
            parameterList.add(parameter.copy());
        }
        this.parameters = unmodifiable ? Collections.unmodifiableList(parameterList) : parameterList;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator i = this.parameters.iterator();
        while (i.hasNext()) {
            buffer.append(';');
            buffer.append(i.next().toString());
        }
        return buffer.toString();
    }

    public final Parameter getParameter(String aName) {
        Iterator i = this.parameters.iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            if (!aName.equalsIgnoreCase(p.getName())) continue;
            return p;
        }
        return null;
    }

    public final ParameterList getParameters(String name) {
        ParameterList list = new ParameterList();
        Iterator i = this.parameters.iterator();
        while (i.hasNext()) {
            Parameter p = (Parameter)i.next();
            if (!p.getName().equalsIgnoreCase(name)) continue;
            list.add(p);
        }
        return list;
    }

    public final boolean add(Parameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Trying to add null Parameter");
        }
        return this.parameters.add(parameter);
    }

    public final boolean replace(Parameter parameter) {
        Iterator i = this.getParameters(parameter.getName()).iterator();
        while (i.hasNext()) {
            this.remove((Parameter)i.next());
        }
        return this.add(parameter);
    }

    public final boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public final Iterator iterator() {
        return this.parameters.iterator();
    }

    public final boolean remove(Parameter parameter) {
        return this.parameters.remove(parameter);
    }

    public final void removeAll(String paramName) {
        ParameterList params = this.getParameters(paramName);
        this.parameters.removeAll(params.parameters);
    }

    public final int size() {
        return this.parameters.size();
    }

    public final boolean equals(Object arg0) {
        if (arg0 instanceof ParameterList) {
            ParameterList p = (ParameterList)arg0;
            return ObjectUtils.equals(this.parameters, p.parameters);
        }
        return super.equals(arg0);
    }

    public final int hashCode() {
        return new HashCodeBuilder().append(this.parameters).toHashCode();
    }
}

