/*
 * Decompiled with CFR 0.152.
 */
package com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.component;

import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.Component;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.ComponentList;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.Date;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.DateTime;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.Dur;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.Parameter;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.Period;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.PeriodList;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.PropertyList;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.ValidationException;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.Validator;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.component.CalendarComponent;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.component.VAlarm;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.parameter.Value;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Clazz;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Created;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Description;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.DtEnd;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.DtStamp;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.DtStart;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Duration;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Geo;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.LastModified;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Location;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Method;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Organizer;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Priority;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.RecurrenceId;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Sequence;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Status;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Summary;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Transp;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Uid;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Url;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.util.CompatibilityHints;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.util.ComponentValidator;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.util.Dates;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.util.PropertyValidator;
import com.joestelmach.natty.repackaged.org.apache.commons.lang.ObjectUtils;
import com.joestelmach.natty.repackaged.org.apache.commons.lang.builder.HashCodeBuilder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class VEvent
extends CalendarComponent {
    private static final long serialVersionUID = 2547948989200697335L;
    private final Map methodValidators = new HashMap();
    private ComponentList alarms;

    public VEvent() {
        super("VEVENT");
        this.methodValidators.put(Method.ADD, new AddValidator());
        this.methodValidators.put(Method.CANCEL, new CancelValidator());
        this.methodValidators.put(Method.COUNTER, new CounterValidator());
        this.methodValidators.put(Method.DECLINE_COUNTER, new DeclineCounterValidator());
        this.methodValidators.put(Method.PUBLISH, new PublishValidator());
        this.methodValidators.put(Method.REFRESH, new RefreshValidator());
        this.methodValidators.put(Method.REPLY, new ReplyValidator());
        this.methodValidators.put(Method.REQUEST, new RequestValidator());
        this.alarms = new ComponentList();
        this.getProperties().add(new DtStamp());
    }

    public VEvent(PropertyList properties) {
        super("VEVENT", properties);
        this.methodValidators.put(Method.ADD, new AddValidator());
        this.methodValidators.put(Method.CANCEL, new CancelValidator());
        this.methodValidators.put(Method.COUNTER, new CounterValidator());
        this.methodValidators.put(Method.DECLINE_COUNTER, new DeclineCounterValidator());
        this.methodValidators.put(Method.PUBLISH, new PublishValidator());
        this.methodValidators.put(Method.REFRESH, new RefreshValidator());
        this.methodValidators.put(Method.REPLY, new ReplyValidator());
        this.methodValidators.put(Method.REQUEST, new RequestValidator());
        this.alarms = new ComponentList();
    }

    public VEvent(PropertyList properties, ComponentList alarms) {
        super("VEVENT", properties);
        this.methodValidators.put(Method.ADD, new AddValidator());
        this.methodValidators.put(Method.CANCEL, new CancelValidator());
        this.methodValidators.put(Method.COUNTER, new CounterValidator());
        this.methodValidators.put(Method.DECLINE_COUNTER, new DeclineCounterValidator());
        this.methodValidators.put(Method.PUBLISH, new PublishValidator());
        this.methodValidators.put(Method.REFRESH, new RefreshValidator());
        this.methodValidators.put(Method.REPLY, new ReplyValidator());
        this.methodValidators.put(Method.REQUEST, new RequestValidator());
        this.alarms = alarms;
    }

    public VEvent(Date start, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new Summary(summary));
    }

    public VEvent(Date start, Date end, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new DtEnd(end));
        this.getProperties().add(new Summary(summary));
    }

    public VEvent(Date start, Dur duration, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new Duration(duration));
        this.getProperties().add(new Summary(summary));
    }

    public final ComponentList getAlarms() {
        return this.alarms;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        b.append("BEGIN");
        b.append(':');
        b.append(this.getName());
        b.append("\r\n");
        b.append(this.getProperties());
        b.append(this.getAlarms());
        b.append("END");
        b.append(':');
        b.append(this.getName());
        b.append("\r\n");
        return b.toString();
    }

    public final void validate(boolean recurse) throws ValidationException {
        Iterator iterator = this.getAlarms().iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (!(component instanceof VAlarm)) {
                throw new ValidationException("Component [" + component.getName() + "] may not occur in VEVENT");
            }
            ((VAlarm)component).validate(recurse);
        }
        if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
            PropertyValidator.getInstance().assertOne("UID", this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        }
        PropertyValidator.getInstance().assertOneOrLess("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("GEO", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("TRANSP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        Status status = (Status)this.getProperty("STATUS");
        if (!(status == null || Status.VEVENT_TENTATIVE.getValue().equals(status.getValue()) || Status.VEVENT_CONFIRMED.getValue().equals(status.getValue()) || Status.VEVENT_CANCELLED.getValue().equals(status.getValue()))) {
            throw new ValidationException("Status property [" + status.toString() + "] is not applicable for VEVENT");
        }
        try {
            PropertyValidator.getInstance().assertNone("DTEND", this.getProperties());
        }
        catch (ValidationException ve) {
            PropertyValidator.getInstance().assertNone("DURATION", this.getProperties());
        }
        if (this.getProperty("DTEND") != null) {
            DtStart start = (DtStart)this.getProperty("DTSTART");
            DtEnd end = (DtEnd)this.getProperty("DTEND");
            if (start != null) {
                Parameter startValue = start.getParameter("VALUE");
                Parameter endValue = end.getParameter("VALUE");
                boolean startEndValueMismatch = false;
                if (endValue != null) {
                    if (startValue != null && !endValue.equals(startValue)) {
                        startEndValueMismatch = true;
                    } else if (startValue == null && !Value.DATE_TIME.equals(endValue)) {
                        startEndValueMismatch = true;
                    }
                } else if (startValue != null && !Value.DATE_TIME.equals(startValue)) {
                    startEndValueMismatch = true;
                }
                if (startEndValueMismatch) {
                    throw new ValidationException("Property [DTEND] must have the same [VALUE] as [DTSTART]");
                }
            }
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    protected Validator getValidator(Method method) {
        return (Validator)this.methodValidators.get(method);
    }

    public final PeriodList getConsumedTime(Date rangeStart, Date rangeEnd) {
        return this.getConsumedTime(rangeStart, rangeEnd, true);
    }

    public final PeriodList getConsumedTime(Date rangeStart, Date rangeEnd, boolean normalise) {
        PeriodList periods = new PeriodList();
        if (!Transp.TRANSPARENT.equals(this.getProperty("TRANSP")) && !(periods = this.calculateRecurrenceSet(new Period(new DateTime(rangeStart), new DateTime(rangeEnd)))).isEmpty() && normalise) {
            periods = periods.normalise();
        }
        return periods;
    }

    public final VEvent getOccurrence(Date date) throws IOException, URISyntaxException, ParseException {
        PeriodList consumedTime = this.getConsumedTime(date, date);
        Iterator i = consumedTime.iterator();
        while (i.hasNext()) {
            Period p = (Period)i.next();
            if (!p.getStart().equals(date)) continue;
            VEvent occurrence = (VEvent)this.copy();
            occurrence.getProperties().add(new RecurrenceId(date));
            return occurrence;
        }
        return null;
    }

    public final Clazz getClassification() {
        return (Clazz)this.getProperty("CLASS");
    }

    public final Created getCreated() {
        return (Created)this.getProperty("CREATED");
    }

    public final Description getDescription() {
        return (Description)this.getProperty("DESCRIPTION");
    }

    public final DtStart getStartDate() {
        return (DtStart)this.getProperty("DTSTART");
    }

    public final Geo getGeographicPos() {
        return (Geo)this.getProperty("GEO");
    }

    public final LastModified getLastModified() {
        return (LastModified)this.getProperty("LAST-MODIFIED");
    }

    public final Location getLocation() {
        return (Location)this.getProperty("LOCATION");
    }

    public final Organizer getOrganizer() {
        return (Organizer)this.getProperty("ORGANIZER");
    }

    public final Priority getPriority() {
        return (Priority)this.getProperty("PRIORITY");
    }

    public final DtStamp getDateStamp() {
        return (DtStamp)this.getProperty("DTSTAMP");
    }

    public final Sequence getSequence() {
        return (Sequence)this.getProperty("SEQUENCE");
    }

    public final Status getStatus() {
        return (Status)this.getProperty("STATUS");
    }

    public final Summary getSummary() {
        return (Summary)this.getProperty("SUMMARY");
    }

    public final Transp getTransparency() {
        return (Transp)this.getProperty("TRANSP");
    }

    public final Url getUrl() {
        return (Url)this.getProperty("URL");
    }

    public final RecurrenceId getRecurrenceId() {
        return (RecurrenceId)this.getProperty("RECURRENCE-ID");
    }

    public final DtEnd getEndDate() {
        return this.getEndDate(true);
    }

    public final DtEnd getEndDate(boolean deriveFromDuration) {
        DtEnd dtEnd = (DtEnd)this.getProperty("DTEND");
        if (dtEnd == null && deriveFromDuration && this.getDuration() != null) {
            DtStart dtStart = this.getStartDate();
            Duration vEventDuration = this.getDuration();
            dtEnd = new DtEnd(Dates.getInstance(vEventDuration.getDuration().getTime(dtStart.getDate()), (Value)dtStart.getParameter("VALUE")));
            if (dtStart.isUtc()) {
                dtEnd.setUtc(true);
            }
        }
        return dtEnd;
    }

    public final Duration getDuration() {
        return (Duration)this.getProperty("DURATION");
    }

    public final Uid getUid() {
        return (Uid)this.getProperty("UID");
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof VEvent) {
            return super.equals(arg0) && ObjectUtils.equals(this.alarms, ((VEvent)arg0).getAlarms());
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getName()).append(this.getProperties()).append(this.getAlarms()).toHashCode();
    }

    public Component copy() throws ParseException, IOException, URISyntaxException {
        VEvent copy = (VEvent)super.copy();
        copy.alarms = new ComponentList(this.alarms);
        return copy;
    }

    private class RequestValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private RequestValidator() {
        }

        public void validate() throws ValidationException {
            if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
                PropertyValidator.getInstance().assertOneOrMore("ATTENDEE", VEvent.this.getProperties());
            }
            PropertyValidator.getInstance().assertOne("DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTART", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("SUMMARY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VEvent.this.getProperties());
            Iterator i = VEvent.this.getAlarms().iterator();
            while (i.hasNext()) {
                VAlarm alarm = (VAlarm)i.next();
                alarm.validate(Method.REQUEST);
            }
        }
    }

    private class ReplyValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private ReplyValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("ATTENDEE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTSTART", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SUMMARY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VEvent.this.getProperties());
            ComponentValidator.assertNone("VALARM", VEvent.this.getAlarms());
        }
    }

    private class RefreshValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private RefreshValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("ATTENDEE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("ATTACH", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("CONTACT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("DTSTART", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("EXDATE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("EXRULE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("RDATE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("RELATED-TO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("REQUEST-STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("RRULE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("SUMMARY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("URL", VEvent.this.getProperties());
            ComponentValidator.assertNone("VALARM", VEvent.this.getAlarms());
        }
    }

    private class PublishValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private PublishValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTART", VEvent.this.getProperties());
            if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
                PropertyValidator.getInstance().assertOne("ORGANIZER", VEvent.this.getProperties());
                PropertyValidator.getInstance().assertOne("SUMMARY", VEvent.this.getProperties());
            }
            PropertyValidator.getInstance().assertOne("UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VEvent.this.getProperties());
            if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
                PropertyValidator.getInstance().assertNone("ATTENDEE", VEvent.this.getProperties());
            }
            PropertyValidator.getInstance().assertNone("REQUEST-STATUS", VEvent.this.getProperties());
            Iterator i = VEvent.this.getAlarms().iterator();
            while (i.hasNext()) {
                VAlarm alarm = (VAlarm)i.next();
                alarm.validate(Method.PUBLISH);
            }
        }
    }

    private class DeclineCounterValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private DeclineCounterValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("ATTACH", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("ATTENDEE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("CONTACT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("DTSTART", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("EXDATE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("EXRULE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("RDATE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("RELATED-TO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("RRULE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("SUMMARY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("URL", VEvent.this.getProperties());
            ComponentValidator.assertNone("VALARM", VEvent.this.getAlarms());
        }
    }

    private class CounterValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private CounterValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTART", VEvent.this.getProperties());
            if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
                PropertyValidator.getInstance().assertOne("ORGANIZER", VEvent.this.getProperties());
            }
            PropertyValidator.getInstance().assertOne("SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("SUMMARY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VEvent.this.getProperties());
            Iterator i = VEvent.this.getAlarms().iterator();
            while (i.hasNext()) {
                VAlarm alarm = (VAlarm)i.next();
                alarm.validate(Method.COUNTER);
            }
        }
    }

    private class CancelValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private CancelValidator() {
        }

        public final void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTART", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTSTART", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SUMMARY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("REQUEST-STATUS", VEvent.this.getProperties());
            ComponentValidator.assertNone("VALARM", VEvent.this.getAlarms());
        }
    }

    private class AddValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private AddValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("DTSTAMP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTART", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("SEQUENCE", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("SUMMARY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTEND", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DURATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("GEO", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LOCATION", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PRIORITY", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RESOURCES", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("TRANSP", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("RECURRENCE-ID", VEvent.this.getProperties());
            PropertyValidator.getInstance().assertNone("REQUEST-STATUS", VEvent.this.getProperties());
            Iterator i = VEvent.this.getAlarms().iterator();
            while (i.hasNext()) {
                VAlarm alarm = (VAlarm)i.next();
                alarm.validate(Method.ADD);
            }
        }
    }
}

