/*
 * Decompiled with CFR 0.152.
 */
package com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.component;

import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.Component;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.ComponentList;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.Date;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.Dur;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.PropertyList;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.ValidationException;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.Validator;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.component.CalendarComponent;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.component.VAlarm;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Clazz;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Completed;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Created;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Description;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.DtStamp;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.DtStart;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Due;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Duration;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Geo;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.LastModified;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Location;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Method;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Organizer;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.PercentComplete;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Priority;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.RecurrenceId;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Sequence;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Status;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Summary;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Uid;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.Url;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.util.CompatibilityHints;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.util.ComponentValidator;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.util.PropertyValidator;
import com.joestelmach.natty.repackaged.org.apache.commons.lang.ObjectUtils;
import com.joestelmach.natty.repackaged.org.apache.commons.lang.builder.HashCodeBuilder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class VToDo
extends CalendarComponent {
    private static final long serialVersionUID = -269658210065896668L;
    private final Map methodValidators = new HashMap();
    private ComponentList alarms;

    public VToDo() {
        super("VTODO");
        this.methodValidators.put(Method.ADD, new AddValidator());
        this.methodValidators.put(Method.CANCEL, new CancelValidator());
        this.methodValidators.put(Method.COUNTER, new CounterValidator());
        this.methodValidators.put(Method.DECLINE_COUNTER, new DeclineCounterValidator());
        this.methodValidators.put(Method.PUBLISH, new PublishValidator());
        this.methodValidators.put(Method.REFRESH, new RefreshValidator());
        this.methodValidators.put(Method.REPLY, new ReplyValidator());
        this.methodValidators.put(Method.REQUEST, new RequestValidator());
        this.alarms = new ComponentList();
        this.getProperties().add(new DtStamp());
    }

    public VToDo(PropertyList properties) {
        super("VTODO", properties);
        this.methodValidators.put(Method.ADD, new AddValidator());
        this.methodValidators.put(Method.CANCEL, new CancelValidator());
        this.methodValidators.put(Method.COUNTER, new CounterValidator());
        this.methodValidators.put(Method.DECLINE_COUNTER, new DeclineCounterValidator());
        this.methodValidators.put(Method.PUBLISH, new PublishValidator());
        this.methodValidators.put(Method.REFRESH, new RefreshValidator());
        this.methodValidators.put(Method.REPLY, new ReplyValidator());
        this.methodValidators.put(Method.REQUEST, new RequestValidator());
        this.alarms = new ComponentList();
    }

    public VToDo(Date start, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new Summary(summary));
    }

    public VToDo(Date start, Date due, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new Due(due));
        this.getProperties().add(new Summary(summary));
    }

    public VToDo(Date start, Dur duration, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new Duration(duration));
        this.getProperties().add(new Summary(summary));
    }

    public final ComponentList getAlarms() {
        return this.alarms;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("BEGIN");
        buffer.append(':');
        buffer.append(this.getName());
        buffer.append("\r\n");
        buffer.append(this.getProperties());
        buffer.append(this.getAlarms());
        buffer.append("END");
        buffer.append(':');
        buffer.append(this.getName());
        buffer.append("\r\n");
        return buffer.toString();
    }

    public final void validate(boolean recurse) throws ValidationException {
        Iterator iterator = this.getAlarms().iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (!(component instanceof VAlarm)) {
                throw new ValidationException("Component [" + component.getName() + "] may not occur in VTODO");
            }
            ((VAlarm)component).validate(recurse);
        }
        if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
            PropertyValidator.getInstance().assertOne("UID", this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        }
        PropertyValidator.getInstance().assertOneOrLess("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("COMPLETED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("GEO", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("PERCENT-COMPLETE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        Status status = (Status)this.getProperty("STATUS");
        if (!(status == null || Status.VTODO_NEEDS_ACTION.getValue().equals(status.getValue()) || Status.VTODO_COMPLETED.getValue().equals(status.getValue()) || Status.VTODO_IN_PROCESS.getValue().equals(status.getValue()) || Status.VTODO_CANCELLED.getValue().equals(status.getValue()))) {
            throw new ValidationException("Status property [" + status.toString() + "] may not occur in VTODO");
        }
        try {
            PropertyValidator.getInstance().assertNone("DUE", this.getProperties());
        }
        catch (ValidationException ve) {
            PropertyValidator.getInstance().assertNone("DURATION", this.getProperties());
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    protected Validator getValidator(Method method) {
        return (Validator)this.methodValidators.get(method);
    }

    public final Clazz getClassification() {
        return (Clazz)this.getProperty("CLASS");
    }

    public final Completed getDateCompleted() {
        return (Completed)this.getProperty("COMPLETED");
    }

    public final Created getCreated() {
        return (Created)this.getProperty("CREATED");
    }

    public final Description getDescription() {
        return (Description)this.getProperty("DESCRIPTION");
    }

    public final DtStart getStartDate() {
        return (DtStart)this.getProperty("DTSTART");
    }

    public final Geo getGeographicPos() {
        return (Geo)this.getProperty("GEO");
    }

    public final LastModified getLastModified() {
        return (LastModified)this.getProperty("LAST-MODIFIED");
    }

    public final Location getLocation() {
        return (Location)this.getProperty("LOCATION");
    }

    public final Organizer getOrganizer() {
        return (Organizer)this.getProperty("ORGANIZER");
    }

    public final PercentComplete getPercentComplete() {
        return (PercentComplete)this.getProperty("PERCENT-COMPLETE");
    }

    public final Priority getPriority() {
        return (Priority)this.getProperty("PRIORITY");
    }

    public final DtStamp getDateStamp() {
        return (DtStamp)this.getProperty("DTSTAMP");
    }

    public final Sequence getSequence() {
        return (Sequence)this.getProperty("SEQUENCE");
    }

    public final Status getStatus() {
        return (Status)this.getProperty("STATUS");
    }

    public final Summary getSummary() {
        return (Summary)this.getProperty("SUMMARY");
    }

    public final Url getUrl() {
        return (Url)this.getProperty("URL");
    }

    public final RecurrenceId getRecurrenceId() {
        return (RecurrenceId)this.getProperty("RECURRENCE-ID");
    }

    public final Duration getDuration() {
        return (Duration)this.getProperty("DURATION");
    }

    public final Due getDue() {
        return (Due)this.getProperty("DUE");
    }

    public final Uid getUid() {
        return (Uid)this.getProperty("UID");
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof VToDo) {
            return super.equals(arg0) && ObjectUtils.equals(this.alarms, ((VToDo)arg0).getAlarms());
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getName()).append(this.getProperties()).append(this.getAlarms()).toHashCode();
    }

    public Component copy() throws ParseException, IOException, URISyntaxException {
        VToDo copy = (VToDo)super.copy();
        copy.alarms = new ComponentList(this.alarms);
        return copy;
    }

    private class RequestValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private RequestValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOneOrMore("ATTENDEE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTART", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("PRIORITY", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("SUMMARY", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DUE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DURATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("GEO", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LOCATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PERCENT-COMPLETE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RESOURCES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("REQUEST-STATUS", VToDo.this.getProperties());
            Iterator i = VToDo.this.getAlarms().iterator();
            while (i.hasNext()) {
                VAlarm alarm = (VAlarm)i.next();
                alarm.validate(Method.REQUEST);
            }
        }
    }

    private class ReplyValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private ReplyValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOneOrMore("ATTENDEE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTSTART", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DUE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DURATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("GEO", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LOCATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PERCENT-COMPLETE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PRIORITY", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RESOURCES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SUMMARY", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VToDo.this.getProperties());
            ComponentValidator.assertNone("VALARM", VToDo.this.getAlarms());
        }
    }

    private class RefreshValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private RefreshValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("ATTENDEE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("ATTACH", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("CATEGORIES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("CLASS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("COMMENT", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("CONTACT", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("CREATED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("DESCRIPTION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("DTSTART", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("DUE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("DURATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("EXDATE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("EXRULE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("GEO", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("LAST-MODIFIED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("LOCATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("ORGANIZER", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("PERCENT-COMPLETE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("PRIORITY", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("RDATE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("RELATED-TO", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("REQUEST-STATUS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("RESOURCES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("RRULE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("SEQUENCE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("STATUS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("URL", VToDo.this.getProperties());
            ComponentValidator.assertNone("VALARM", VToDo.this.getAlarms());
        }
    }

    private class PublishValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private PublishValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("DTSTAMP", VToDo.this.getProperties());
            if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
                PropertyValidator.getInstance().assertOne("ORGANIZER", VToDo.this.getProperties());
                PropertyValidator.getInstance().assertOne("PRIORITY", VToDo.this.getProperties());
            }
            PropertyValidator.getInstance().assertOne("SUMMARY", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTSTART", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DUE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DURATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("GEO", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LOCATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PERCENT-COMPLETE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RESOURCES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("ATTENDEE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("REQUEST-STATUS", VToDo.this.getProperties());
            Iterator i = VToDo.this.getAlarms().iterator();
            while (i.hasNext()) {
                VAlarm alarm = (VAlarm)i.next();
                alarm.validate(Method.PUBLISH);
            }
        }
    }

    private class DeclineCounterValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private DeclineCounterValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOneOrMore("ATTENDEE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("SEQUENCE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTSTART", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DUE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DURATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("GEO", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LOCATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PERCENT-COMPLETE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PRIORITY", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RESOURCES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VToDo.this.getProperties());
            ComponentValidator.assertNone("VALARM", VToDo.this.getAlarms());
        }
    }

    private class CounterValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private CounterValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOneOrMore("ATTENDEE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("PRIORITY", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("SUMMARY", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTSTART", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DUE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DURATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("GEO", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LOCATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PERCENT-COMPLETE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RESOURCES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RRULE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VToDo.this.getProperties());
            Iterator i = VToDo.this.getAlarms().iterator();
            while (i.hasNext()) {
                VAlarm alarm = (VAlarm)i.next();
                alarm.validate(Method.COUNTER);
            }
        }
    }

    private class CancelValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private CancelValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("UID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("SEQUENCE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTSTART", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DUE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DURATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("GEO", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LOCATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PERCENT-COMPLETE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RESOURCES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PRIORITY", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("REQUEST-STATUS", VToDo.this.getProperties());
            ComponentValidator.assertNone("VALARM", VToDo.this.getAlarms());
        }
    }

    private class AddValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private AddValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("DTSTAMP", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("PRIORITY", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("SEQUENCE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("SUMMARY", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("COMMENT", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTSTART", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DUE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DURATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("GEO", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LOCATION", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("PERCENT-COMPLETE", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RESOURCES", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("RECURRENCE-ID", VToDo.this.getProperties());
            PropertyValidator.getInstance().assertNone("REQUEST-STATUS", VToDo.this.getProperties());
            Iterator i = VToDo.this.getAlarms().iterator();
            while (i.hasNext()) {
                VAlarm alarm = (VAlarm)i.next();
                alarm.validate(Method.ADD);
            }
        }
    }
}

