/*
 * Decompiled with CFR 0.152.
 */
package com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property;

import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.DateTime;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.Dur;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.Parameter;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.ParameterList;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.PropertyFactory;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.PropertyFactoryImpl;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.ValidationException;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.parameter.Value;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.UtcProperty;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.util.ParameterValidator;
import java.text.ParseException;

public class Trigger
extends UtcProperty {
    private static final long serialVersionUID = 5049421499261722194L;
    private Dur duration;

    public Trigger() {
        super("TRIGGER", PropertyFactoryImpl.getInstance());
    }

    public Trigger(ParameterList aList, String aValue) {
        super("TRIGGER", aList, (PropertyFactory)PropertyFactoryImpl.getInstance());
        this.setValue(aValue);
    }

    public Trigger(Dur duration) {
        super("TRIGGER", PropertyFactoryImpl.getInstance());
        this.setDuration(duration);
    }

    public Trigger(ParameterList aList, Dur duration) {
        super("TRIGGER", aList, (PropertyFactory)PropertyFactoryImpl.getInstance());
        this.setDuration(duration);
    }

    public Trigger(DateTime dateTime) {
        super("TRIGGER", PropertyFactoryImpl.getInstance());
        this.setDateTime(dateTime);
    }

    public Trigger(ParameterList aList, DateTime dateTime) {
        super("TRIGGER", aList, (PropertyFactory)PropertyFactoryImpl.getInstance());
        this.setDateTime(dateTime);
    }

    public final void validate() throws ValidationException {
        super.validate();
        Parameter relParam = this.getParameter("RELATED");
        Parameter valueParam = this.getParameter("VALUE");
        if (relParam != null || !Value.DATE_TIME.equals(valueParam)) {
            ParameterValidator.getInstance().assertOneOrLess("RELATED", this.getParameters());
            ParameterValidator.getInstance().assertNullOrEqual(Value.DURATION, this.getParameters());
            if (this.getDuration() == null) {
                throw new ValidationException("Duration value not specified");
            }
        } else {
            ParameterValidator.getInstance().assertOne("VALUE", this.getParameters());
            ParameterValidator.getInstance().assertNullOrEqual(Value.DATE_TIME, this.getParameters());
            if (this.getDateTime() == null) {
                throw new ValidationException("DATE-TIME value not specified");
            }
        }
    }

    public final Dur getDuration() {
        return this.duration;
    }

    public final void setValue(String aValue) {
        try {
            super.setValue(aValue);
            this.duration = null;
        }
        catch (ParseException pe) {
            this.duration = new Dur(aValue);
            super.setDateTime(null);
        }
    }

    public final String getValue() {
        if (this.duration != null) {
            return this.duration.toString();
        }
        return super.getValue();
    }

    public final void setDateTime(DateTime dateTime) {
        super.setDateTime(dateTime);
        this.duration = null;
        this.getParameters().replace(Value.DATE_TIME);
    }

    public final void setDuration(Dur duration) {
        this.duration = duration;
        super.setDateTime(null);
        if (this.getParameter("VALUE") != null) {
            this.getParameters().replace(Value.DURATION);
        }
    }
}

