/*
 * Decompiled with CFR 0.152.
 */
package com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property;

import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.DateTime;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.ParameterList;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.PropertyFactory;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.TimeZone;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.ValidationException;
import com.joestelmach.natty.repackaged.net.fortuna.ical4j.model.property.DateProperty;

public abstract class UtcProperty
extends DateProperty {
    private static final long serialVersionUID = 4850079486497487938L;

    public UtcProperty(String name, ParameterList parameters, PropertyFactory factory) {
        super(name, parameters, factory);
        this.setDate(new DateTime(true));
    }

    public UtcProperty(String name, PropertyFactory factory) {
        super(name, factory);
        this.setDate(new DateTime(true));
    }

    public final DateTime getDateTime() {
        return (DateTime)this.getDate();
    }

    public void setDateTime(DateTime dateTime) {
        if (dateTime != null) {
            dateTime.setUtc(true);
        }
        this.setDate(dateTime);
    }

    public void setTimeZone(TimeZone timezone) {
        throw new UnsupportedOperationException("Cannot set timezone for UTC properties");
    }

    public void validate() throws ValidationException {
        super.validate();
        if (this.getDate() != null && !(this.getDate() instanceof DateTime)) {
            throw new ValidationException("Property must have a DATE-TIME value");
        }
        DateTime dateTime = (DateTime)this.getDate();
        if (dateTime != null && !dateTime.isUtc()) {
            throw new ValidationException(this.getName() + ": DATE-TIME value must be specified in UTC time");
        }
    }
}

